/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.xml;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.components.Bracket;
import com.biotechvana.phylograph.components.Scale;
import com.biotechvana.phylograph.components.TextLabel;
import com.biotechvana.phylograph.readers.ColorReader;
import com.biotechvana.phylograph.readers.FontReader;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XML2Components {
    FontReader fontReader = new FontReader();
    ColorReader colorReader = new ColorReader();

    public void createComponents(InternalF internalF, File xmlInput) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().parse(xmlInput);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (doc == null) {
            System.out.println("No existe el fichero");
            System.exit(0);
        }
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String componentType = children.item(i).getNodeName().trim();
            if (componentType.equalsIgnoreCase("label")) {
                this.createLabels(internalF, children.item(i));
                continue;
            }
            if (componentType.equalsIgnoreCase("bracket")) {
                this.createBrackets(internalF, children.item(i));
                continue;
            }
            if (!componentType.equalsIgnoreCase("scale")) continue;
            this.editScale(internalF, children.item(i));
        }
    }

    private void createLabels(InternalF internalF, Node label) {
        NamedNodeMap attributes = label.getAttributes();
        int id = Integer.parseInt(attributes.getNamedItem("id").getNodeValue());
        int x = Integer.parseInt(attributes.getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(attributes.getNamedItem("y").getNodeValue());
        int w = Integer.parseInt(attributes.getNamedItem("w").getNodeValue());
        int h = Integer.parseInt(attributes.getNamedItem("h").getNodeValue());
        int paddingX = Integer.parseInt(attributes.getNamedItem("paddingX").getNodeValue());
        int paddingY = Integer.parseInt(attributes.getNamedItem("paddingY").getNodeValue());
        String horizontalLabel = attributes.getNamedItem("horizontal").getNodeValue();
        Font font = this.fontReader.getFont(attributes.getNamedItem("font").getNodeValue());
        Color colorText = this.colorReader.getColor(attributes.getNamedItem("colorText").getNodeValue());
        Color colorBorder = this.colorReader.getColor(attributes.getNamedItem("colorBorder").getNodeValue());
        Color colorBack = this.colorReader.getColor(attributes.getNamedItem("colorBack").getNodeValue());
        String borderLabel = attributes.getNamedItem("border").getNodeValue();
        String text = label.getTextContent();
        boolean horizontal = true;
        boolean transparent = Boolean.parseBoolean(attributes.getNamedItem("transparent").getNodeValue());
        boolean border = true;
        if (horizontalLabel.equalsIgnoreCase("false")) {
            horizontal = false;
        }
        if (borderLabel.equalsIgnoreCase("false")) {
            border = false;
        }
        TextLabel textlabel = new TextLabel(internalF, text, x, y);
        internalF.getPanelTree().add(textlabel);
        internalF.getLabelList().add(textlabel);
        textlabel.changeFont(font);
        textlabel.setColorText(colorText);
        textlabel.setColorBack(colorBack);
        textlabel.setColorBorder(colorBorder);
        textlabel.setBorder(border);
        textlabel.setHorizontal(horizontal);
        textlabel.setTransparent(transparent);
        textlabel.setPaddingX(paddingX);
        textlabel.setPaddingY(paddingY);
    }

    private void createBrackets(InternalF internalF, Node bracketNode) {
        NamedNodeMap attributes = bracketNode.getAttributes();
        int id = Integer.parseInt(attributes.getNamedItem("id").getNodeValue());
        int x = Integer.parseInt(attributes.getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(attributes.getNamedItem("y").getNodeValue());
        int w = Integer.parseInt(attributes.getNamedItem("w").getNodeValue());
        int h = Integer.parseInt(attributes.getNamedItem("h").getNodeValue());
        Color colorLine = this.colorReader.getColor(attributes.getNamedItem("colorLine").getNodeValue());
        Bracket bracket = new Bracket(internalF, x, y, w, h);
        internalF.getPanelTree().add(bracket);
        internalF.getBracketList().add(bracket);
        bracket.setColorLine(colorLine);
    }

    private void editScale(InternalF internalF, Node scaleNode) {
        NamedNodeMap attributes = scaleNode.getAttributes();
        int x = Integer.parseInt(attributes.getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(attributes.getNamedItem("y").getNodeValue());
        int w = Integer.parseInt(attributes.getNamedItem("w").getNodeValue());
        int h = Integer.parseInt(attributes.getNamedItem("h").getNodeValue());
        Font font = this.fontReader.getFont(attributes.getNamedItem("font").getNodeValue());
        Color colorScale = this.colorReader.getColor(attributes.getNamedItem("colorScale").getNodeValue());
        Scale scale = internalF.getScale();
        scale.setBounds(x, y, w, h);
        scale.setFont(font);
        scale.setColorScale(colorScale);
        scale.setForeground(colorScale);
    }
}

