/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.utils;

public class ToPolar {
    public double[] rectangularToPolar(double x, double y) {
        double r = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        double cosPhy = x / r;
        double sinPhy = y / r;
        double phy = Math.asin(sinPhy);
        if (!(cosPhy >= 0.0) || sinPhy >= 0.0) {
            // empty if block
        }
        if (cosPhy < 0.0 && sinPhy >= 0.0) {
            phy = Math.PI - phy;
        }
        if (cosPhy < 0.0 && sinPhy < 0.0) {
            phy = Math.PI - phy;
        }
        if (cosPhy >= 0.0 && sinPhy < 0.0) {
            phy = Math.PI * 2 + phy;
        }
        double[] res = new double[]{r, phy};
        return res;
    }

    public double[] polarToRectangular(double r, double p) {
        double x = r * Math.cos(p);
        double y = r * Math.sin(p);
        double[] res = new double[]{x, y};
        return res;
    }

    public double degToRad(double deg) {
        double rad = Math.PI / 180 * deg;
        return rad;
    }

    public double radToDeg(double rad) {
        double deg = 57.29577951308232 * rad;
        return deg;
    }

    public double getAngle(double x1, double y1, double x2, double y2) {
        double a = x2 - x1;
        double b = y2 - y1;
        double[] polarRes = this.rectangularToPolar(a, b);
        return polarRes[1];
    }
}

