/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.treeutils;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.utils.ImageDim;

public class FitTree {
    public void fitTreeToWindow(InternalF intf) {
        ImageDim myTreeDim = intf.getTreeDim();
        double myWindowWidth = 0.0;
        double myWindowHeight = 0.0;
        myWindowWidth = intf.getWidth() - 100;
        myWindowHeight = intf.getHeight() - 100;
        if (intf.getTreeView().equalsIgnoreCase("unrooted") || intf.getTreeView().equalsIgnoreCase("polar") || intf.getTreeView().equalsIgnoreCase("polarDist")) {
            double minWindowSize = myWindowWidth;
            if (minWindowSize > myWindowHeight) {
                minWindowSize = myWindowHeight;
            }
            myWindowWidth = minWindowSize;
            myWindowHeight = minWindowSize;
        }
        double myTreeWidth = myTreeDim.getWidth() + myTreeDim.getWidth() * 0.1;
        double myNewFactorW = myWindowWidth / myTreeWidth;
        double myTreeHeight = myTreeDim.getHeight() + myTreeDim.getHeight() * 0.1;
        double myNewFactorH = myWindowHeight / myTreeHeight;
        double factorAdjust = (myNewFactorW + myNewFactorH) / 2.0;
        if (intf.getTreeView().equalsIgnoreCase("polar") || intf.getTreeView().equalsIgnoreCase("polarDist")) {
            intf.setScaleFactorX(factorAdjust);
            intf.setScaleFactorY(factorAdjust);
        } else {
            intf.setScaleFactorX(myNewFactorW);
            intf.setScaleFactorY(myNewFactorH);
        }
        intf.moveScale();
    }
}

