/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.tables;

import com.biotechvana.phylograph.utils.FileToString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class TableURL
extends JDialog {
    private static final long serialVersionUID = 6356887231441823196L;
    private DefaultTableModel tableModel = new DefaultTableModel();
    private JTable table = new JTable(this.tableModel);
    private String[] columnNames = new String[]{"OTU", "URL"};
    private String[][] data = new String[][]{{"", ""}};
    private FileToString fts = new FileToString();
    private JFrame frame;

    public TableURL(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        Container cp = this.getContentPane();
        this.setSize(new Dimension(600, 400));
        this.frame = frame;
        cp.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.table);
        this.table.setSelectionMode(0);
        cp.add((Component)scroll, "Center");
        this.tableModel.setDataVector(this.data, this.columnNames);
        this.tableModel.addTableModelListener(new MyTableModelListener(this.table));
    }

    public Object[][] getOtuValues() {
        Object[][] res = new Object[this.tableModel.getRowCount() - 1][this.tableModel.getColumnCount()];
        for (int row = 0; row < this.tableModel.getRowCount() - 1; ++row) {
            for (int col = 0; col < this.tableModel.getColumnCount(); ++col) {
                res[row][col] = this.tableModel.getValueAt(row, col);
            }
        }
        return res;
    }

    public void exportOtu(String prefFile) {
        JFileChooser chooser = new JFileChooser(prefFile);
        chooser.setDialogTitle("Export OTU-URL table");
        chooser.setMultiSelectionEnabled(false);
        int sel = chooser.showSaveDialog(null);
        if (sel != 0) {
            return;
        }
        File output = chooser.getSelectedFile();
        Object[][] values = this.getOtuValues();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            sb.append(String.valueOf(values[i][0]) + ";" + String.valueOf(values[i][1]) + "\r\n");
        }
        try {
            FileWriter fw = new FileWriter(output);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(sb.toString());
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String importOtu() {
        File input = this.openFileDialog();
        int res = this.readAttachmentFile(input);
        if (input == null || res != 0) {
            return null;
        }
        return input.getAbsolutePath();
    }

    public String importOtu(String fileName) {
        File input = new File(fileName);
        if (!input.exists()) {
            return null;
        }
        this.readAttachmentFile(input);
        return input.getAbsolutePath();
    }

    private File openFileDialog() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Import OTU-URL table");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        int sel = chooser.showOpenDialog(this.frame);
        if (sel != 0) {
            return null;
        }
        File input = chooser.getSelectedFile();
        return input;
    }

    private int readAttachmentFile(File file) {
        String fileContent = this.fts.getString(file);
        String[] lines = fileContent.split("\n");
        ArrayList<String> cleanLines = new ArrayList<String>();
        if (lines[0].indexOf("#urls") < 0) {
            JOptionPane.showMessageDialog(this, "Not a valid URL file");
            return 0;
        }
        for (int i = 1; i < lines.length; ++i) {
            String[] parts = lines[i].split(";");
            if (parts.length <= 1) continue;
            cleanLines.add(lines[i]);
        }
        Object[][] otulist = new Object[cleanLines.size()][2];
        for (int i = 0; i < cleanLines.size(); ++i) {
            String[] parts = ((String)cleanLines.get(i)).split(";");
            if (parts.length <= 1) continue;
            otulist[i][0] = parts[0].replace("\"", "");
            otulist[i][1] = parts[1].replace("\"", "");
        }
        this.tableModel.setDataVector(otulist, this.columnNames);
        return 1;
    }

    public class MyTableModelListener
    implements TableModelListener {
        JTable table;

        public MyTableModelListener(JTable table) {
            this.table = table;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            int mColIndex = e.getColumn();
            switch (e.getType()) {
                case 1: {
                    for (int r = firstRow; r <= lastRow; ++r) {
                    }
                    break;
                }
                case 0: {
                    if (firstRow == -1) {
                        if (mColIndex != -1) break;
                        break;
                    }
                    for (int r = firstRow; r <= lastRow; ++r) {
                        if (r == this.table.getRowCount() - 1) {
                            Object value0 = this.table.getValueAt(r, 0);
                            Object value1 = this.table.getValueAt(r, 1);
                            if (value0.toString().length() > 0 && value1.toString().length() > 0) {
                                TableURL.this.tableModel.addRow(new Object[]{"", ""});
                            }
                        }
                        if (mColIndex != -1) continue;
                    }
                    break;
                }
                case -1: {
                    for (int r = firstRow; r <= lastRow; ++r) {
                    }
                    break;
                }
            }
        }
    }
}

