/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.project;

import com.biotechvana.phylograph.Controller;
import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.TreeType;
import com.biotechvana.phylograph.TreeUtils;
import com.biotechvana.phylograph.View;
import com.biotechvana.phylograph.readers.ColorReader;
import com.biotechvana.phylograph.readers.FontReader;
import com.biotechvana.phylograph.readers.PreferenceManager;
import com.biotechvana.phylograph.readers.ProjectReader;
import com.biotechvana.phylograph.utils.FileToString;
import com.biotechvana.phylograph.xml.XML2Components;
import com.biotechvana.phylograph.xml.Xml2TreeList2;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ProjectOpener {
    private InternalF internalF = null;
    private ProjectReader projectReader = new ProjectReader();
    private FontReader fontReader = new FontReader();
    private ColorReader colorReader = new ColorReader();
    private FileToString fileToString = new FileToString();
    private TreeType treeType = new TreeType();
    private TreeUtils treeUtils = new TreeUtils();
    private double scaleValue = 0.0;
    private File attachmentFile = null;
    private HashMap<?, ?> mapAttrib = null;
    private File fileTree = null;
    private Xml2TreeList2 x2t = null;
    private int tType = 0;
    private double maxLength = 0.0;
    private TreeElement treeList = null;
    private PreferenceManager prefsManager = new PreferenceManager();

    public InternalF open(View view, Controller controller) {
        this.attachmentFile = this.openFileDialog(view);
        if (this.attachmentFile == null) {
            return null;
        }
        this.mapAttrib = this.getMapAttrib(this.attachmentFile);
        this.fileTree = this.getTreeFile(this.mapAttrib);
        this.x2t = new Xml2TreeList2(this.fileTree);
        this.treeList = this.x2t.getTreeList();
        this.tType = this.treeType.getTreeType(this.treeList);
        this.maxLength = this.treeUtils.getMaxLength(this.treeList);
        this.scaleValue = this.computeScaleValue(this.tType, this.maxLength);
        this.internalF = this.createInternalF(view, controller);
        this.initInternalF(view);
        return this.internalF;
    }

    public InternalF open(View view, Controller controller, String fileName) {
        this.attachmentFile = new File(fileName);
        this.mapAttrib = this.getMapAttrib(this.attachmentFile);
        this.fileTree = this.getTreeFile(this.mapAttrib);
        this.x2t = new Xml2TreeList2(this.fileTree);
        this.treeList = this.x2t.getTreeList();
        this.tType = this.treeType.getTreeType(this.treeList);
        this.maxLength = this.treeUtils.getMaxLength(this.treeList);
        this.scaleValue = this.computeScaleValue(this.tType, this.maxLength);
        this.internalF = this.createInternalF(view, controller);
        this.initInternalF(view);
        return this.internalF;
    }

    private File openFileDialog(View view) {
        FileDialog dialog;
        String projectDir = this.prefsManager.getPreference("project_dir");
        Frame frame = (Frame)SwingUtilities.getWindowAncestor(view);
        if (projectDir != null) {
            dialog = new FileDialog(frame, "Open a Phylograph project", 0);
            dialog.setDirectory(projectDir);
        } else {
            dialog = new FileDialog(frame, "Open a Phylograph project", 0);
        }
        dialog.setMultipleMode(false);
        dialog.setVisible(true);
        String selectedFile = dialog.getFile();
        if (selectedFile == null) {
            return null;
        }
        String filePath = dialog.getDirectory() + selectedFile;
        this.prefsManager.savePreference("project_dir", dialog.getDirectory());
        return new File(filePath);
    }

    private HashMap<?, ?> getMapAttrib(File input) {
        return this.projectReader.getParams(this.fileToString.getString(input));
    }

    private File getTreeFile(HashMap<?, ?> hashMap) {
        File fileTree = null;
        try {
            fileTree = new File(hashMap.get("tree").toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fileTree;
    }

    private double computeScaleValue(int treeType, double maxLength) {
        if (treeType == 1) {
            return 0.0;
        }
        if (treeType == 2) {
            if (maxLength <= 1.0) {
                return 1.0;
            }
            if (maxLength <= 10.0) {
                return 10.0;
            }
            return 100.0;
        }
        if (treeType == 3 || treeType == 4) {
            return 0.1;
        }
        return 0.0;
    }

    private InternalF createInternalF(View view, Controller controller) {
        return new InternalF(controller, view, this.treeList, this.attachmentFile.getName(), this.attachmentFile.getAbsolutePath(), this.tType, view.getDesktop().getWidth(), view.getDesktop().getHeight(), this.scaleValue);
    }

    private void initInternalF(View view) {
        view.getDesktop().add(this.internalF);
        this.internalF.createElements();
        this.internalF.updatePanel();
        this.internalF.changeTreeType(this.mapAttrib.get("treeType").toString());
        File fileComponents = new File(this.mapAttrib.get("components").toString());
        XML2Components xml2Components = new XML2Components();
        xml2Components.createComponents(this.internalF, fileComponents);
        this.checkScale();
        this.checkBootstrap();
        try {
            this.checkAttachment();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Invalid attachment file");
        }
        try {
            this.checkUrl();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Invalid url file");
        }
        try {
            this.checkClusters();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Invalid cluster file");
        }
        this.internalF.setInverted(Boolean.parseBoolean(this.mapAttrib.get("inverted").toString()));
        this.checkFonts();
    }

    private void checkScale() {
        this.internalF.setScaleFactorX(Double.parseDouble(this.mapAttrib.get("scaleFactorX").toString()));
        this.internalF.setScaleFactorY(Double.parseDouble(this.mapAttrib.get("scaleFactorY").toString()));
        this.internalF.setMarginX(Integer.parseInt(this.mapAttrib.get("marginX").toString()));
        this.internalF.setMarginY(Integer.parseInt(this.mapAttrib.get("marginY").toString()));
    }

    private void checkBootstrap() {
        boolean showBootstrap = Boolean.parseBoolean(this.mapAttrib.get("bootstrap").toString());
        if (showBootstrap) {
            float minBootstrap = Float.parseFloat(this.mapAttrib.get("bootstrapMinValue").toString());
            this.internalF.setBootstrap(true, minBootstrap);
        }
    }

    private void checkAttachment() throws IOException {
        boolean showAttachment = Boolean.parseBoolean(this.mapAttrib.get("attachment").toString());
        if (showAttachment) {
            String attachmentFileName = this.mapAttrib.get("attachmentFile").toString();
            int attachmentDistance = Integer.parseInt(this.mapAttrib.get("attachmentDistance").toString());
            this.internalF.getTableAttachment().importOtu(attachmentFileName);
            this.internalF.setAttachmentFileName(attachmentFileName);
            this.internalF.setAttachmentDistance(attachmentDistance);
            this.internalF.attachmentShow();
        }
    }

    private void checkUrl() throws IOException {
        boolean showUrl = Boolean.parseBoolean(this.mapAttrib.get("url").toString());
        if (showUrl) {
            String urlFileName = this.mapAttrib.get("urlFile").toString();
            this.internalF.getTableURL().importOtu(urlFileName);
            this.internalF.setUrlFileName(urlFileName);
            this.internalF.linkShow();
        }
    }

    private void checkClusters() throws IOException {
        boolean showCluster = Boolean.parseBoolean(this.mapAttrib.get("cluster").toString());
        if (showCluster) {
            String clusterFileName = this.mapAttrib.get("clusterFile").toString();
            this.internalF.setAttachmentFileName(clusterFileName);
            this.internalF.showAllClusters();
        }
    }

    private void checkFonts() {
        this.internalF.setFonts(new Font[]{this.fontReader.getFont(this.mapAttrib.get("fontOtu").toString()), this.fontReader.getFont(this.mapAttrib.get("fontOtuLink").toString()), this.fontReader.getFont(this.mapAttrib.get("fontLabel").toString()), this.fontReader.getFont(this.mapAttrib.get("fontBootstrap").toString()), this.fontReader.getFont(this.mapAttrib.get("fontAttachment").toString()), this.fontReader.getFont(this.mapAttrib.get("fontCluster").toString())}, new Color[]{this.colorReader.getColor(this.mapAttrib.get("colorOtu").toString()), this.colorReader.getColor(this.mapAttrib.get("colorOtuLink").toString()), this.colorReader.getColor(this.mapAttrib.get("colorLabel").toString()), this.colorReader.getColor(this.mapAttrib.get("colorBootstrap").toString()), this.colorReader.getColor(this.mapAttrib.get("colorAttachment").toString()), this.colorReader.getColor(this.mapAttrib.get("colorCluster").toString())});
        this.internalF.setDefaultFonts(new Font[]{this.fontReader.getFont(this.mapAttrib.get("fontOtu").toString()), this.fontReader.getFont(this.mapAttrib.get("fontOtuLink").toString()), this.fontReader.getFont(this.mapAttrib.get("fontLabel").toString()), this.fontReader.getFont(this.mapAttrib.get("fontBootstrap").toString()), this.fontReader.getFont(this.mapAttrib.get("fontAttachment").toString()), this.fontReader.getFont(this.mapAttrib.get("fontCluster").toString())}, new Color[]{this.colorReader.getColor(this.mapAttrib.get("colorOtu").toString()), this.colorReader.getColor(this.mapAttrib.get("colorOtuLink").toString()), this.colorReader.getColor(this.mapAttrib.get("colorLabel").toString()), this.colorReader.getColor(this.mapAttrib.get("colorBootstrap").toString()), this.colorReader.getColor(this.mapAttrib.get("colorAttachment").toString()), this.colorReader.getColor(this.mapAttrib.get("colorCluster").toString())});
    }
}

