/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.internalf;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;

public class TreeTypeChanger {
    public void changeTreeType(InternalF internalF, String type, double maxLength) {
        String treeView = internalF.getTreeView();
        if (type.equalsIgnoreCase(treeView)) {
            return;
        }
        if (type.equalsIgnoreCase("Phenogram")) {
            this.setPhenogram(internalF);
        } else if (type.equalsIgnoreCase("Cladogram")) {
            this.setCladogram(internalF);
        } else if (type.equalsIgnoreCase("Slanted")) {
            this.setSlanted(internalF);
        } else if (type.equalsIgnoreCase("Phylogram")) {
            this.setPhylogram(internalF);
        } else if (type.equalsIgnoreCase("Unrooted")) {
            this.setUnrooted(internalF);
        } else if (type.equalsIgnoreCase("PolarDist")) {
            this.setPolarDist(internalF);
        } else if (type.equalsIgnoreCase("Polar")) {
            this.setPolar(internalF);
        }
        TreeElement coords = internalF.getTreeGram().getCoords(internalF.getTreeList(), type, maxLength, internalF.negativeType);
        internalF.setTreeList(coords);
        internalF.createElements();
        internalF.fitTreeToWindow();
        internalF.getPanelTree().setTreeView(type);
        internalF.getPanelTree().setTreeList(internalF.getTreeList());
        internalF.moveElements(internalF.getTreeList());
        internalF.updatePanel();
    }

    private void setCladogram(InternalF internalF) {
        internalF.setTreeView("cladogram");
        internalF.setMarginX(20);
        if (internalF.isRooted()) {
            internalF.setRooted(false);
        }
        if (internalF.getAuxList() != null) {
            internalF.getTreeList().clear();
            internalF.setTreeList(null);
            internalF.setTreeList(internalF.getAuxList());
            internalF.getAuxList().clear();
            internalF.setAuxList(null);
        }
        if (internalF.getScale() != null) {
            internalF.getScale().setVisible(false);
        }
        if (internalF.getTreeType() == 3 || internalF.getTreeType() == 4) {
            internalF.setScaleFactorX(1.0);
            internalF.setScaleInc(0.5);
        }
    }

    private void setSlanted(InternalF internalF) {
        internalF.setTreeView("slanted");
        internalF.setMarginX(20);
        if (internalF.isRooted()) {
            internalF.setRooted(false);
        }
        if (internalF.getAuxList() != null) {
            internalF.getTreeList().clear();
            internalF.setTreeList(null);
            internalF.setTreeList(internalF.getAuxList());
            internalF.getAuxList().clear();
            internalF.setAuxList(null);
        }
        if (internalF.getScale() != null) {
            internalF.getScale().setVisible(false);
        }
        if (internalF.getTreeType() == 3 || internalF.getTreeType() == 4) {
            internalF.setScaleFactorX(1.0);
            internalF.setScaleInc(0.5);
        }
    }

    private void setPhenogram(InternalF internalF) {
        internalF.setTreeView("phenogram");
        internalF.setMarginX(20);
        if (internalF.isRooted()) {
            internalF.setRooted(false);
        }
        if (internalF.getAuxList() != null) {
            internalF.getTreeList().clear();
            internalF.setTreeList(null);
            internalF.setTreeList(internalF.getAuxList());
            internalF.getAuxList().clear();
            internalF.setAuxList(null);
        }
        if (internalF.getScale() != null) {
            internalF.getScale().setVisible(false);
        }
    }

    private void setPhylogram(InternalF internalF) {
        internalF.setTreeView("phylogram");
        internalF.setMarginX(20);
        if (internalF.isRooted()) {
            internalF.setRooted(false);
        }
        if (internalF.getAuxList() != null) {
            internalF.getTreeList().clear();
            internalF.setTreeList(null);
            internalF.setTreeList(internalF.getAuxList());
            internalF.getAuxList().clear();
            internalF.setAuxList(null);
        }
        if (internalF.getScale() != null) {
            internalF.getScale().setVisible(true);
        }
        if (internalF.getTreeType() == 3 || internalF.getTreeType() == 4) {
            internalF.setScaleFactorX(1000.0);
            internalF.setScaleInc(500.0);
        }
    }

    private void setUnrooted(InternalF internalF) {
        internalF.setTreeView("unrooted");
        internalF.setMarginX(80);
        if (internalF.isRooted()) {
            internalF.setRooted(false);
        }
        if (internalF.getAuxList() != null) {
            internalF.getAuxList().clear();
            internalF.setAuxList(null);
        }
        internalF.setAuxList(internalF.getTreeList());
        internalF.setTreeList(internalF.getOriginalTreeList());
        if (internalF.getScale() != null) {
            internalF.getScale().setVisible(true);
        }
    }

    private void setPolarDist(InternalF internalF) {
        internalF.setTreeView("polarDist");
        this.polarTypes(internalF);
    }

    private void setPolar(InternalF internalF) {
        internalF.setTreeView("polar");
        this.polarTypes(internalF);
    }

    private void polarTypes(InternalF internalF) {
        internalF.setMarginX(80);
        if (internalF.isRooted()) {
            internalF.setRooted(false);
        }
        if (internalF.getAuxList() != null) {
            internalF.getTreeList().clear();
            internalF.setTreeList(null);
            internalF.setTreeList(internalF.getAuxList());
            internalF.getAuxList().clear();
            internalF.setAuxList(null);
        }
        if (internalF.getScale() != null) {
            internalF.getScale().setVisible(true);
        }
    }
}

