/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.internalf;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.ListToNewick;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;

public class NewickSaver {
    public void saveNewick(InternalF internalF) {
        File output = null;
        boolean hasBootstrap = false;
        int treeType = 1;
        ListToNewick ltn = new ListToNewick();
        output = this.showSaveFileDialog(internalF);
        if (output == null) {
            return;
        }
        treeType = internalF.getTreeType();
        if (treeType == 3 || treeType == 4) {
            hasBootstrap = true;
        }
        String newick = ltn.getNewickString(internalF.getTreeList(), hasBootstrap);
        this.writeNewick(output, newick);
    }

    private File showSaveFileDialog(InternalF internalF) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Select a file");
        int res = chooser.showSaveDialog(internalF);
        if (res == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private void writeNewick(File file, String newick) {
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(newick);
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

