/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.internalf;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.View;
import com.biotechvana.phylograph.exports.ExportHtml;
import com.biotechvana.phylograph.exports.ExportPng;
import com.biotechvana.phylograph.exports.ExportPs;
import com.biotechvana.phylograph.filters.FilterHTML;
import com.biotechvana.phylograph.filters.FilterPNG;
import com.biotechvana.phylograph.filters.FilterPS;
import java.io.File;
import javax.swing.JFileChooser;

public class ExportManager {
    public static final int PNG = 0;
    public static final int HTML = 1;
    public static final int PS = 2;

    public void exportImage(View view, InternalF internalF) {
        ExportPng exportPng = new ExportPng();
        internalF.updatePanel();
        File selectedFile = this.showExportDialog(view, "Export as png image", 0);
        if (selectedFile == null) {
            return;
        }
        exportPng.exportImageFile(internalF, selectedFile);
        internalF.updatePanel();
    }

    public void exportHTMLMap(View view, InternalF internalF) {
        ExportPng exportPng = new ExportPng();
        ExportHtml exportHtml = new ExportHtml();
        File selectedFile = this.showExportDialog(view, "Export image and html map file", 1);
        if (selectedFile == null) {
            return;
        }
        exportPng.exportImageFile(internalF, selectedFile);
        exportHtml.exportHTMLFile(internalF, selectedFile);
        internalF.updatePanel();
    }

    public void exportPostScript(View view, InternalF internalF) {
        ExportPs exportPs = new ExportPs();
        internalF.updatePanel();
        File selectedFile = this.showExportDialog(view, "Export as PostScript", 2);
        if (selectedFile == null) {
            return;
        }
        exportPs.exportPSFile(internalF, selectedFile, internalF.getTreeView());
    }

    private File showExportDialog(View view, String winTitle, int type) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(winTitle);
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        switch (type) {
            case 0: {
                chooser.addChoosableFileFilter(new FilterPNG());
                break;
            }
            case 1: {
                chooser.addChoosableFileFilter(new FilterHTML());
                break;
            }
            case 2: {
                chooser.addChoosableFileFilter(new FilterPS());
                break;
            }
            default: {
                return null;
            }
        }
        int sel = chooser.showSaveDialog(view);
        if (sel == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }
}

