/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.exports;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.components.Attachment;
import com.biotechvana.phylograph.components.Bootstrap;
import com.biotechvana.phylograph.components.Bracket;
import com.biotechvana.phylograph.components.ClusterFull;
import com.biotechvana.phylograph.components.Node;
import com.biotechvana.phylograph.components.Otu;
import com.biotechvana.phylograph.components.Scale;
import com.biotechvana.phylograph.components.TextLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class ExportPs {
    private Otu[] otuArray;
    private Node[] nodeArray;
    private List<TextLabel> textLabelList;
    private List<Attachment> attachmentList;
    private List<Bracket> bracketList;
    private List<ClusterFull> clusterList;
    private Bootstrap[] bootArray;
    private Scale scale;
    private TreeElement treeList;
    private double scaleFactorX;
    private double scaleFactorY;
    private int marginX;
    private int marginY;
    private String[] psNodes;
    private int psNodesCount = 0;
    private String[] psOtus;
    private int psOtusCount = 0;
    private final int psX = 20;
    private final int psY = 800;
    private final int psW = 550;
    private final int psH = 760;
    private static final String DEFAULT_FONT = "Courier";

    public void exportPSFile(InternalF internalF, File output, String treeView) {
        int i;
        this.otuArray = internalF.getOtuArray();
        this.nodeArray = internalF.getNodeArray();
        this.textLabelList = internalF.getLabelList();
        this.attachmentList = internalF.getAttachmentList();
        this.clusterList = internalF.getClusterFullList();
        this.bracketList = internalF.getBracketList();
        this.bootArray = internalF.getBootArray();
        this.scale = internalF.getScale();
        this.treeList = internalF.getTreeList();
        this.scaleFactorX = internalF.getScaleFactorX();
        this.scaleFactorY = internalF.getScaleFactorY();
        this.marginX = internalF.getMarginX();
        this.marginY = internalF.getMarginY();
        double scaleX = 550.0 / internalF.getDim().getWidth();
        double scaleY = 760.0 / internalF.getDim().getHeight();
        StringBuffer sb = new StringBuffer();
        sb.append("%!PS-Adobe-3.1\r\n");
        sb.append("%Procedures\r\n");
        sb.append(this.exportPSProcedures());
        sb.append("%Body\r\n");
        sb.append("/Courier findfont\r\n");
        sb.append("10 scalefont\r\n");
        sb.append("setfont\r\n");
        sb.append("20 800 translate\r\n");
        if (scaleX > 1.0) {
            scaleX = 1.0;
        }
        if (scaleY > 1.0) {
            scaleY = 1.0;
        }
        if (scaleX < scaleY) {
            sb.append(scaleX + " " + scaleX + " scale\r\n");
        } else {
            sb.append(scaleY + " " + scaleY + " scale\r\n");
        }
        sb.append("%draw nodes\r\n");
        this.psNodes = new String[this.nodeArray.length];
        if (treeView.compareToIgnoreCase("slanted") == 0 || treeView.compareToIgnoreCase("unrooted") == 0) {
            this.exportPSNodesSlanted(this.treeList);
        } else {
            this.exportPSNodes(this.treeList);
        }
        this.psNodesCount = 0;
        sb.append("20 800 moveto\r\n");
        for (i = 0; i < this.psNodes.length; ++i) {
            if (this.psNodes[i] == null) continue;
            sb.append(this.psNodes[i]);
        }
        sb.append("%draw Otu lines\r\n");
        this.psOtus = new String[this.otuArray.length];
        if (treeView.compareToIgnoreCase("slanted") == 0 || treeView.compareToIgnoreCase("unrooted") == 0) {
            this.exportPSOtusSlanted(this.treeList);
        } else {
            this.exportPSOtus(this.treeList);
        }
        this.psOtusCount = 0;
        sb.append("20 800 moveto\r\n");
        for (i = 0; i < this.psOtus.length; ++i) {
            if (this.psOtus[i] == null) continue;
            sb.append(this.psOtus[i]);
        }
        sb.append("%draw Otu text\r\n");
        sb.append(this.exportPSOtuText());
        sb.append(this.exportPSBootstrap());
        sb.append(this.exportPSLabel());
        sb.append(this.exportPSBracket());
        sb.append(this.exportPSAttachment());
        sb.append(this.exportPSScale());
        if (this.clusterList != null) {
            sb.append(this.ExportPSClusters());
        }
        sb.append("showpage\r\n");
        if (!output.getAbsolutePath().endsWith(".ps")) {
            output = new File(output.getAbsolutePath() + ".ps");
        }
        try {
            FileWriter fw = new FileWriter(output);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(sb.toString());
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String exportPSProcedures() {
        String procedures = "/drawNode{\r\n\trlineto\r\n\trmoveto\r\n\trlineto\r\n\trmoveto\r\n\trlineto\r\n\trmoveto\r\n\tstroke\r\n}def\r\n/drawNodeSlanted{\r\n\trlineto\r\n\trmoveto\r\n\trlineto\r\n\trmoveto\r\n\trlineto\r\n\trmoveto\r\n\tstroke\r\n}def\r\n/drawOtuLine{\r\n\trlineto\r\n\trmoveto\r\n\tstroke\r\n}def\r\n/drawLabel{\r\n\trmoveto\r\n\trlineto\r\n\trlineto\r\n\trlineto\r\n\trlineto\r\n\tstroke\r\n}def\r\n/drawOtu{\r\n\tmoveto\r\n\tsetrgbcolor\r\n\tshow\r\n}def\r\n/drawBootstrap{\r\n\tmoveto\r\n\tsetrgbcolor\r\n\tshow\r\n}def\r\n/drawRectangle{\r\n\trmoveto\r\n\trlineto\r\n\trlineto\r\n\trlineto\r\n\trlineto\r\n\tstroke\r\n}def\r\n/fillRectangle{\r\n\trmoveto\r\n\trlineto\r\n\trlineto\r\n\trlineto\r\n\trlineto\r\n\tfill\r\n}def\r\n";
        return procedures;
    }

    private void exportPSNodes(TreeElement parent) {
        if (parent.isNode()) {
            int xp;
            int x = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
            int y = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
            int yh = (int)(parent.getYChildHigh() * this.scaleFactorY) + this.marginY;
            int yl = (int)(parent.getYChildLow() * this.scaleFactorY) + this.marginY;
            try {
                xp = (int)(parent.getFather().getX() * this.scaleFactorX) + this.marginX;
            }
            catch (Exception ex) {
                xp = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
            }
            int lineH = x - xp;
            int lineVh = yh - y;
            int lineVl = y - yl;
            Color foreground = parent.getColorLine();
            Object node = "";
            node = parent.isVisible() ? x + " -" + y + " moveto\r\n" + (double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n" + lineH + " 0 " + -lineH + " 0  0 " + lineVh + " 0 -" + Math.abs(lineVh) + " 0 -" + Math.abs(lineVl) + " 0 " + lineVl + " drawNode\r\n" : x + " -" + y + " moveto\r\n" + (double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n" + -lineH + " 0 rlineto\r\n stroke\r\n";
            this.psNodes[this.psNodesCount++] = node;
        }
        if (!parent.isVisible()) {
            return;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.exportPSNodes((TreeElement)parent.get(i));
        }
    }

    private void exportPSNodesSlanted(TreeElement parent) {
        if (parent.isNode() && parent.isVisible()) {
            int yp;
            int xp;
            int x = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
            int y = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
            try {
                xp = (int)(parent.getFather().getX() * this.scaleFactorX) + this.marginX;
            }
            catch (Exception ex) {
                xp = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
            }
            try {
                yp = (int)(parent.getFather().getY() * this.scaleFactorY) + this.marginY;
            }
            catch (Exception ex) {
                yp = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
            }
            Color foreground = parent.getColorLine();
            String node = x + " -" + y + " moveto\r\n" + (double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n" + xp + " -" + yp + " lineto\r\nstroke\r\n";
            this.psNodes[this.psNodesCount++] = node;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.exportPSNodesSlanted((TreeElement)parent.get(i));
        }
    }

    private void exportPSOtus(TreeElement parent) {
        if (!parent.isVisible()) {
            return;
        }
        if (!parent.isNode()) {
            int x = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
            int y = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
            int xp = (int)(parent.getFather().getX() * this.scaleFactorX) + this.marginX;
            int lineH = x - xp;
            Color foreground = parent.getColorLine();
            String otu = x + " -" + y + " moveto\r\n" + (double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n" + lineH + " 0 " + -1 * lineH + " 0 drawOtuLine\r\n";
            this.psOtus[this.psOtusCount++] = otu;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.exportPSOtus((TreeElement)parent.get(i));
        }
    }

    private void exportPSOtusSlanted(TreeElement parent) {
        if (!parent.isVisible()) {
            return;
        }
        if (!parent.isNode()) {
            int yp;
            int x = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
            int y = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
            int xp = (int)(parent.getFather().getX() * this.scaleFactorX) + this.marginX;
            try {
                yp = (int)(parent.getFather().getY() * this.scaleFactorY) + this.marginY;
            }
            catch (Exception ex) {
                yp = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
            }
            Color foreground = parent.getColorLine();
            String otu = x + " -" + y + " moveto\r\n" + (double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n" + xp + " -" + yp + " lineto\r\nstroke\r\n";
            this.psOtus[this.psOtusCount++] = otu;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.exportPSOtusSlanted((TreeElement)parent.get(i));
        }
    }

    private String exportPSOtuText() {
        StringBuffer sb = new StringBuffer();
        sb.append("20 800 moveto\r\n");
        for (int i = 0; i < this.otuArray.length; ++i) {
            Otu otu = this.otuArray[i];
            boolean visible = otu.isVisible();
            Font font = otu.getFont();
            String realFontName = this.getRealFontName(font.getName(), font.getStyle());
            int x = otu.getX();
            int y = otu.getY() + font.getSize();
            Color foreground = otu.getForeground();
            String text = otu.getText();
            if (!visible) continue;
            sb.append("/" + realFontName + " findfont\r\n");
            sb.append(font.getSize() + " scalefont\r\n");
            sb.append("setfont\r\n");
            sb.append("(" + text + ") " + (double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " " + x + " -" + y + " drawOtu\r\n");
        }
        sb.append("0 0 0 setrgbcolor\r\n");
        return sb.toString();
    }

    private String exportPSBootstrap() {
        StringBuffer sb = new StringBuffer();
        sb.append("%draw bootstrap\r\n");
        sb.append("20 800 moveto\r\n");
        if (this.bootArray != null) {
            for (int i = 0; i < this.bootArray.length; ++i) {
                Bootstrap bootstrap = this.bootArray[i];
                if (bootstrap == null) continue;
                String text = bootstrap.getText();
                boolean isVisible = bootstrap.isVisible();
                Font font = bootstrap.getFont();
                int x = bootstrap.getX();
                int y = bootstrap.getY() + font.getSize();
                String realFontName = this.getRealFontName(font.getName(), font.getStyle());
                Color foreground = bootstrap.getForeground();
                if (!(Double.parseDouble(text) > 0.0) || !isVisible) continue;
                sb.append("/" + realFontName + " findfont\r\n");
                sb.append(font.getSize() + " scalefont\r\n");
                sb.append("setfont\r\n");
                sb.append("(" + text + ") " + (double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " " + x + " -" + y + " drawBootstrap\r\n");
            }
        }
        return sb.toString();
    }

    private String exportPSLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append("20 800 moveto\r\n");
        for (int i = 0; i < this.textLabelList.size(); ++i) {
            TextLabel textLabel = this.textLabelList.get(i);
            String text = textLabel.getText();
            Font font = textLabel.getFont();
            int x = textLabel.getX();
            int y = textLabel.getY() + font.getSize();
            int w = textLabel.getWidth();
            int h = textLabel.getHeight();
            FontMetrics fontMetrics = textLabel.getFontMetrics(font);
            int stringHeight = textLabel.getFont().getSize();
            int stringWidth = fontMetrics.stringWidth(text);
            int paddingY = h - stringHeight;
            int paddingX = w - stringWidth - 4;
            String realFontName = this.getRealFontName(font.getName(), font.getStyle());
            Color foreground = textLabel.getForeground();
            Color borderColor = textLabel.getColorBorder();
            Color background = textLabel.getColorBack();
            boolean hasBorder = textLabel.hasBorder();
            sb.append((double)background.getRed() / 255.0 + " " + (double)background.getGreen() / 255.0 + " " + (double)background.getBlue() / 255.0 + " setrgbcolor\r\n");
            sb.append(x + paddingX + " -" + y + " moveto\r\n");
            sb.append("0 -" + h + " -" + w + " 0 0 " + h + " " + w + " 0 -" + paddingX + " -" + paddingY + " fillRectangle\r\n");
            if (hasBorder) {
                sb.append((double)borderColor.getRed() / 255.0 + " " + (double)borderColor.getGreen() / 255.0 + " " + (double)borderColor.getBlue() / 255.0 + " setrgbcolor\r\n");
                sb.append(x + paddingX + " -" + y + " moveto\r\n");
                sb.append("0 -" + h + " -" + w + " 0 0 " + h + " " + w + " 0 -" + paddingX + " -" + paddingY + " drawRectangle\r\n");
            }
            sb.append("/" + realFontName + " findfont\r\n");
            sb.append(font.getSize() + " scalefont\r\n");
            sb.append("setfont\r\n");
            sb.append((double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n");
            sb.append(x + paddingX / 2 - 2 + " -" + (y + paddingY / 2 - 2) + " moveto\r\n");
            sb.append("(" + text + ") show\r\n");
        }
        return sb.toString();
    }

    private String exportPSBracket() {
        StringBuffer sb = new StringBuffer();
        sb.append("0 800 moveto\r\n");
        for (int i = 0; i < this.bracketList.size(); ++i) {
            Bracket bracket = this.bracketList.get(i);
            int x = bracket.getX();
            int y = bracket.getY();
            int w = bracket.getWidth();
            int h = bracket.getHeight();
            Color foreground = bracket.getColorLine();
            sb.append((double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n");
            sb.append(x + " -" + y + " moveto\r\n");
            sb.append(w + " 0 rlineto\r\n");
            sb.append("0 -" + h + " rlineto\r\n");
            sb.append("-" + w + " 0 rlineto\r\n");
            sb.append("stroke\r\n");
        }
        return sb.toString();
    }

    private String exportPSAttachment() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.attachmentList.size(); ++i) {
            Attachment attachment = this.attachmentList.get(i);
            Font font = attachment.getFont();
            int x = attachment.getX();
            int y = attachment.getY() + font.getSize();
            String realFontName = this.getRealFontName(font.getName(), font.getStyle());
            Color foreground = attachment.getForeground();
            String text = attachment.getText();
            sb.append("/" + realFontName + " findfont\r\n");
            sb.append(font.getSize() + " scalefont\r\n");
            sb.append("setfont\r\n");
            sb.append((double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n");
            sb.append(x + " -" + y + " moveto\r\n");
            sb.append("(" + text + ") show\r\n");
        }
        return sb.toString();
    }

    private String exportPSScale() {
        StringBuffer sb = new StringBuffer();
        if (this.scale != null && this.scale.isVisible()) {
            int lineWidth = (int)(this.scale.getScaleValue() * this.scaleFactorX);
            int textWidth = this.scale.getTextWidth();
            int paddingX = (lineWidth - textWidth) / 2;
            int paddingY = this.scale.getFont().getSize();
            String value = String.valueOf(this.scale.getScaleValue());
            Color foreground = this.scale.getColorScale();
            int x = this.scale.getX();
            int y = this.scale.getY();
            Font font = this.scale.getFont();
            String realFontName = this.getRealFontName(font.getName(), font.getStyle());
            if (value.equals("1.0")) {
                value = "1";
            } else if (value.equals("10.0")) {
                value = "10";
            } else if (value.equals("100.0")) {
                value = "100";
            } else if (value.equals("1000.0")) {
                value = "1000";
            }
            sb.append((double)foreground.getRed() / 255.0 + " " + (double)foreground.getGreen() / 255.0 + " " + (double)foreground.getBlue() / 255.0 + " setrgbcolor\r\n");
            sb.append(x + " -" + (y + paddingY + 4) + " moveto\r\n");
            sb.append(lineWidth + " 0 rlineto\r\n");
            sb.append("stroke\r\n");
            sb.append("/" + realFontName + " findfont\r\n");
            sb.append(font.getSize() + " scalefont\r\n");
            sb.append("setfont\r\n");
            sb.append(x + paddingX + " -" + (y + paddingY) + " moveto\r\n");
            sb.append("(" + value + ") show\r\n");
        }
        return sb.toString();
    }

    private String ExportPSClusters() {
        StringBuffer sb = new StringBuffer();
        for (ClusterFull cluster : this.clusterList) {
            int boxY;
            int boxX;
            int textY;
            int textX;
            int strokeWidth;
            String text = cluster.getClusterName();
            int x = cluster.getX();
            int y = cluster.getY();
            Color colorStroke = cluster.getColorStroke();
            Color colorText = cluster.getColorText();
            Color colorBackground = cluster.getColorBackground();
            Color colorBorder = cluster.getColorBorder();
            boolean inverted = cluster.isInverted();
            boolean border = cluster.isBorder();
            boolean background = cluster.isBackground();
            int stringWidth = cluster.getStringWidth();
            int stringHeight = cluster.getStringHeight();
            Font font = cluster.getFont();
            int height = cluster.getHeight();
            int width = cluster.getWidth();
            int paddingX = cluster.getPaddingX();
            int paddingY = cluster.getPaddingY();
            String realFontName = this.getRealFontName(font.getName(), font.getStyle());
            if (inverted) {
                strokeWidth = width - stringWidth - 10 - paddingX * 2;
                textX = x;
                textY = y + height / 2 + stringHeight / 4;
                boxX = x + paddingX;
                boxY = y + height / 2 + stringHeight / 2;
                sb.append((double)colorStroke.getRed() / 255.0 + " " + (double)colorStroke.getGreen() / 255.0 + " " + (double)colorStroke.getBlue() / 255.0 + " setrgbcolor\r\n");
                sb.append(x + width + " -" + y + " moveto\r\n");
                sb.append("-" + strokeWidth + " 0 rlineto\r\n");
                sb.append("0 -" + height + " rlineto\r\n");
                sb.append(strokeWidth + " 0 rlineto\r\n");
                sb.append("stroke\r\n");
                if (background) {
                    sb.append((double)colorBackground.getRed() / 255.0 + " " + (double)colorBackground.getGreen() / 255.0 + " " + (double)colorBackground.getBlue() / 255.0 + " setrgbcolor\r\n");
                    sb.append(boxX + " -" + (boxY - paddingY - stringHeight) + " moveto\r\n");
                    sb.append("0 -" + (paddingY * 2 + stringHeight) + " -" + (paddingX * 2 + stringWidth + 1) + " 0 0 -" + (paddingY * 2 + stringHeight) + " " + (paddingX * 2 + stringWidth + 1) + " 0 -" + paddingX + " -" + paddingY + " fillRectangle\r\n");
                }
                if (border) {
                    sb.append((double)colorBorder.getRed() / 255.0 + " " + (double)colorBorder.getGreen() / 255.0 + " " + (double)colorBorder.getBlue() / 255.0 + " setrgbcolor\r\n");
                    sb.append(boxX + " -" + (boxY - paddingY - stringHeight) + " moveto\r\n");
                    sb.append("0 +" + (paddingY * 2 + stringHeight) + " -" + (paddingX * 2 + stringWidth + 1) + " 0 0 -" + (paddingY * 2 + stringHeight) + " " + (paddingX * 2 + stringWidth + 1) + " 0 -" + paddingX + " -" + paddingY + " drawRectangle\r\n");
                }
                sb.append("/" + realFontName + " findfont\r\n");
                sb.append(font.getSize() + " scalefont\r\n");
                sb.append("setfont\r\n");
                sb.append((double)colorText.getRed() / 255.0 + " " + (double)colorText.getGreen() / 255.0 + " " + (double)colorText.getBlue() / 255.0 + " setrgbcolor\r\n");
                sb.append(textX + paddingX + " -" + textY + " moveto\r\n");
                sb.append("(" + text + ") show\r\n");
                continue;
            }
            strokeWidth = width - stringWidth - 10 - paddingX * 2;
            textX = x + width - stringWidth;
            textY = y + height / 2 + stringHeight / 4;
            boxX = textX - paddingX;
            boxY = y + height / 2 + stringHeight / 2;
            sb.append((double)colorStroke.getRed() / 255.0 + " " + (double)colorStroke.getGreen() / 255.0 + " " + (double)colorStroke.getBlue() / 255.0 + " setrgbcolor\r\n");
            sb.append(x + " -" + y + " moveto\r\n");
            sb.append(strokeWidth + " 0 rlineto\r\n");
            sb.append("0 -" + height + " rlineto\r\n");
            sb.append("-" + strokeWidth + " 0 rlineto\r\n");
            sb.append("stroke\r\n");
            if (background) {
                sb.append((double)colorBackground.getRed() / 255.0 + " " + (double)colorBackground.getGreen() / 255.0 + " " + (double)colorBackground.getBlue() / 255.0 + " setrgbcolor\r\n");
                sb.append(boxX + " -" + (boxY - paddingY - stringHeight) + " moveto\r\n");
                sb.append("0 -" + (paddingY * 2 + stringHeight) + " -" + (stringWidth + paddingX * 2 + 1) + " 0 0 -" + (paddingY * 2 + stringHeight) + " " + (stringWidth + paddingX * 2 + 1) + " 0 -" + paddingX + " -" + paddingY + " fillRectangle\r\n");
            }
            if (border) {
                sb.append((double)colorBorder.getRed() / 255.0 + " " + (double)colorBorder.getGreen() / 255.0 + " " + (double)colorBorder.getBlue() / 255.0 + " setrgbcolor\r\n");
                sb.append(boxX + " -" + (boxY - paddingY - stringHeight) + " moveto\r\n");
                sb.append("0 +" + (paddingY * 2 + stringHeight) + " -" + (stringWidth + paddingX * 2 + 1) + " 0 0 -" + (paddingY * 2 + stringHeight) + " " + (stringWidth + paddingX * 2 + 1) + " 0 -" + paddingX + " -" + paddingY + " drawRectangle\r\n");
            }
            sb.append("/" + realFontName + " findfont\r\n");
            sb.append(font.getSize() + " scalefont\r\n");
            sb.append("setfont\r\n");
            sb.append((double)colorText.getRed() / 255.0 + " " + (double)colorText.getGreen() / 255.0 + " " + (double)colorText.getBlue() / 255.0 + " setrgbcolor\r\n");
            sb.append(textX - paddingX + " -" + textY + " moveto\r\n");
            sb.append("(" + text + ") show\r\n");
        }
        return sb.toString();
    }

    private String getRealFontName(String fontName, int fontStyle) {
        StringBuffer realFontName = new StringBuffer();
        realFontName.append(DEFAULT_FONT);
        if (realFontName.toString().equalsIgnoreCase("Arial")) {
            switch (fontStyle) {
                case 0: {
                    break;
                }
                case 1: {
                    realFontName.append("Bold");
                    break;
                }
                case 2: {
                    realFontName.append("Italic");
                    break;
                }
                case 3: {
                    realFontName.append("BoldItalic");
                    break;
                }
            }
        } else if (realFontName.toString().equalsIgnoreCase(DEFAULT_FONT)) {
            switch (fontStyle) {
                case 0: {
                    break;
                }
                case 1: {
                    realFontName.append("-Bold");
                    break;
                }
                case 2: {
                    realFontName.append("-Italic");
                    break;
                }
                case 3: {
                    realFontName.append("-BoldItalic");
                    break;
                }
            }
        } else if (realFontName.toString().equalsIgnoreCase("TimesNewRomanPS")) {
            switch (fontStyle) {
                case 0: {
                    realFontName.append("MT");
                    break;
                }
                case 1: {
                    realFontName.append("-BoldMT");
                    break;
                }
                case 2: {
                    realFontName.append("-ItalicMT");
                    break;
                }
                case 3: {
                    realFontName.append("-BoldItalicMT");
                    break;
                }
            }
        }
        return realFontName.toString();
    }
}

