/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.exports;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.components.Attachment;
import com.biotechvana.phylograph.components.Bootstrap;
import com.biotechvana.phylograph.components.Bracket;
import com.biotechvana.phylograph.components.ClusterFull;
import com.biotechvana.phylograph.components.Otu;
import com.biotechvana.phylograph.components.Scale;
import com.biotechvana.phylograph.components.TextLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.border.Border;

public class ExportPng {
    private InternalF internalF;
    private Scale scale;
    private double scaleFactorX;

    public void exportImageFile(InternalF internalF, File output) {
        this.internalF = internalF;
        this.scaleFactorX = internalF.getScaleFactorX();
        BufferedImage bimage = internalF.getPanelTree().getBufferedImage();
        Graphics2D g2 = (Graphics2D)bimage.getGraphics();
        g2.setColor(Color.BLACK);
        this.exportOtu(g2);
        this.exportLabels(g2);
        this.exportAttachments(g2);
        this.exportBrackets(g2);
        this.exportBootstrap(g2);
        this.exportScale(g2);
        this.exportCluster(g2);
        BufferedImage bFinal = bimage;
        if (!output.getAbsolutePath().endsWith(".png")) {
            output = new File(output.getAbsolutePath() + ".png");
        }
        try {
            ImageIO.write((RenderedImage)bFinal, "png", output);
        }
        catch (Exception ex) {
            System.out.println("Image saving failed");
            ex.printStackTrace();
        }
    }

    private void exportOtu(Graphics2D g2) {
        Otu[] otuArray = this.internalF.getOtuArray();
        for (int i = 0; i < otuArray.length; ++i) {
            Otu otu = otuArray[i];
            boolean isVisible = otu.isVisible();
            Font font = otu.getFont();
            Color foreground = otu.getForeground();
            String text = otu.getText();
            int x = otu.getX();
            int y = otu.getY();
            if (!isVisible) continue;
            g2.setFont(font);
            g2.setColor(foreground);
            g2.drawString(text, x, y + font.getSize());
        }
    }

    private void exportLabels(Graphics2D g2) {
        List<TextLabel> textLabelList = this.internalF.getLabelList();
        for (int i = 0; i < textLabelList.size(); ++i) {
            try {
                TextLabel textLabel = textLabelList.get(i);
                String text = textLabel.getText();
                String hText = textLabel.getHText();
                Color backgroundColor = textLabel.getBackground();
                Color foregroundColor = textLabel.getForeground();
                Color borderColor = textLabel.getColorBorder();
                int x = textLabel.getX();
                int y = textLabel.getY();
                int width = textLabel.getWidth();
                int height = textLabel.getHeight();
                Border border = textLabel.getBorder();
                boolean horizontal = textLabel.isHorizontal();
                int stringWidth = textLabel.getStringWidth(textLabel.getText());
                Font font = textLabel.getFont();
                int fontSize = font.getSize();
                int paddingX = textLabel.getPaddingX();
                int paddingY = textLabel.getPaddingY();
                g2.setColor(backgroundColor);
                g2.fillRect(x, y, width, height);
                if (border != null) {
                    g2.setColor(borderColor);
                    g2.drawRect(x, y - 1, width, height);
                }
                if (horizontal) {
                    g2.setFont(font);
                    g2.setColor(foregroundColor);
                    g2.drawString(text, x + paddingX, y + fontSize + paddingY);
                    continue;
                }
                for (int j = 0; j < hText.length(); ++j) {
                    g2.drawString(String.valueOf(hText.charAt(j)), x + 4, y + fontSize * (j + 1) + 4);
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void exportAttachments(Graphics2D g2) {
        List<Attachment> attachmentList = this.internalF.getAttachmentList();
        for (int i = 0; i < attachmentList.size(); ++i) {
            try {
                Attachment attachment = attachmentList.get(i);
                Color foregroundColor = attachment.getForeground();
                Font font = attachment.getFont();
                int fontSize = font.getSize();
                int x = attachment.getX();
                int y = attachment.getY();
                String text = attachment.getText();
                g2.setColor(foregroundColor);
                g2.setFont(font);
                g2.drawString(text, x, y + fontSize);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void exportBrackets(Graphics2D g2) {
        List<Bracket> bracketList = this.internalF.getBracketList();
        for (int i = 0; i < bracketList.size(); ++i) {
            try {
                Bracket bracket = bracketList.get(i);
                int x = bracket.getX();
                int y = bracket.getY();
                int width = bracket.getWidth();
                int height = bracket.getHeight();
                Color foreground = bracket.getForeground();
                g2.setColor(foreground);
                g2.drawLine(x, y, x + width, y);
                g2.drawLine(x, y + height, x + width, y + height);
                g2.drawLine(x + width, y, x + width, y + height);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void exportBootstrap(Graphics2D g2) {
        Bootstrap[] bootArray = this.internalF.getBootArray();
        if (bootArray != null) {
            for (int i = 0; i < bootArray.length; ++i) {
                Bootstrap bootstrap = bootArray[i];
                if (bootstrap == null) continue;
                Font font = bootstrap.getFont();
                boolean isVisible = bootstrap.isVisible();
                int fontSize = font.getSize();
                Color foreground = bootstrap.getForeground();
                String text = bootstrap.getText();
                int x = bootstrap.getX();
                int y = bootstrap.getY();
                if (!isVisible) continue;
                g2.setFont(font);
                g2.setColor(foreground);
                g2.drawString(text, x, y + fontSize);
            }
        }
    }

    private void exportScale(Graphics2D g2) {
        this.scale = this.internalF.getScale();
        if (this.scale != null && this.scale.isVisible()) {
            try {
                Font font = this.scale.getFont();
                int fontSize = font.getSize();
                FontMetrics fm = this.scale.getFontMetrics(font);
                int x = this.scale.getX();
                int y = this.scale.getY();
                int width = this.scale.getWidth();
                int height = this.scale.getHeight();
                Color foregroudColor = this.scale.getForeground();
                String text = this.scale.getText();
                int paddingX = (width - fm.stringWidth(text)) / 2;
                int paddingY = (height + 6 - fm.getHeight()) / 2;
                g2.setColor(foregroudColor);
                g2.setFont(font);
                g2.drawString(this.scale.getText(), x + paddingX, y + fontSize + paddingY);
                g2.drawLine(x, y + height - 2, x + (int)(this.scale.getScaleValue() * this.scaleFactorX), y + height - 2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void exportCluster(Graphics2D g2) {
        List<ClusterFull> clusterFullList = this.internalF.getClusterFullList();
        if (clusterFullList == null) {
            return;
        }
        for (ClusterFull cluster : clusterFullList) {
            int boxY;
            int boxX;
            int textY;
            int textX;
            int strokeWidth;
            String text = cluster.getClusterName();
            int x = cluster.getX();
            int y = cluster.getY();
            Color colorStroke = cluster.getColorStroke();
            Color colorText = cluster.getColorText();
            Color colorBackground = cluster.getColorBackground();
            Color colorBorder = cluster.getColorBorder();
            boolean inverted = cluster.isInverted();
            boolean border = cluster.isBorder();
            int stringWidth = cluster.getStringWidth();
            int stringHeight = cluster.getStringHeight();
            Font font = cluster.getFont();
            int paddingX = cluster.getPaddingX();
            int paddingY = cluster.getPaddingY();
            int height = cluster.getHeight();
            int width = cluster.getWidth();
            if (inverted) {
                strokeWidth = 10 + stringWidth + paddingX * 2;
                textX = x + paddingX;
                textY = y + height / 2 + stringHeight / 4;
                boxX = textX;
                boxY = textY - stringHeight * 3 / 4;
                g2.setColor(colorStroke);
                g2.drawLine(x + width - 1, y + 1, x + strokeWidth, y + 1);
                g2.drawLine(x + width - 1, y + height - 1, x + strokeWidth, y + height - 1);
                g2.drawLine(x + strokeWidth, y + 1, x + strokeWidth, y + height - 1);
                g2.setColor(colorBackground);
                g2.fillRect(boxX - paddingX, boxY - paddingY, stringWidth + paddingX * 2, stringHeight + paddingY * 2);
                if (border) {
                    g2.setColor(colorBorder);
                    g2.drawRect(boxX - paddingX, boxY - paddingY, stringWidth + paddingX * 2, stringHeight + paddingY * 2);
                }
                g2.setFont(font);
                g2.setColor(colorText);
                g2.drawString(text, textX, textY);
                continue;
            }
            strokeWidth = width - stringWidth - 10 - paddingX * 2;
            textX = x + width - stringWidth;
            textY = y + height / 2 + stringHeight / 4;
            boxX = textX - paddingX;
            boxY = textY - stringHeight * 3 / 4;
            g2.setColor(colorStroke);
            g2.drawLine(x + 1, y + 1, x + strokeWidth, y + 1);
            g2.drawLine(x + 1, y + height - 1, x + strokeWidth, y + height - 1);
            g2.drawLine(x + strokeWidth, y + 1, x + strokeWidth, y + height - 1);
            g2.setColor(colorBackground);
            g2.fillRect(boxX - paddingX, boxY - paddingY, stringWidth + paddingX * 2, stringHeight + paddingY * 2);
            if (border) {
                g2.setColor(colorBorder);
                g2.drawRect(boxX - paddingX, boxY - paddingY, stringWidth + paddingX * 2, stringHeight + paddingY * 2);
            }
            g2.setFont(font);
            g2.setColor(colorText);
            g2.drawString(text, textX - paddingX, textY);
        }
    }
}

