/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.exports;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.components.Otu;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ExportHtml {
    public void exportHTMLFile(InternalF internalF, File output) {
        Otu[] otuArray = internalF.getOtuArray();
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("<html>\n");
        sbuffer.append("<head>\n");
        sbuffer.append("</head>\n");
        sbuffer.append("<body>\n");
        sbuffer.append("<img src=\"" + output.getName() + ".png\" border=\"0px\" usemap=\"#map1\"/>\n");
        sbuffer.append("<map name=\"map1\">\n");
        for (int i = 0; i < otuArray.length; ++i) {
            Otu otu = otuArray[i];
            String link = otu.getLink();
            boolean visible = otu.isVisible();
            int x = otu.getX();
            int y = otu.getY();
            int width = otu.getWidth();
            int height = otu.getHeight();
            String text = otu.getText();
            if (link == null || !visible) continue;
            sbuffer.append("<area shape=\"rect\" coords=\"" + x + "," + y + "," + (x + width) + "," + (y + height) + "\" href=\"" + link + "\" title=\"" + text + "\" />\n");
        }
        sbuffer.append("</map>\n");
        sbuffer.append("</body>\n");
        sbuffer.append("</html>\n");
        if (!output.getAbsolutePath().endsWith(".html")) {
            output = new File(output.getAbsolutePath() + ".html");
        }
        try {
            FileWriter fw = new FileWriter(output);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(sbuffer.toString());
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

