/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class FontDialogCluster
extends JDialog {
    private static final long serialVersionUID = 7342635254852750586L;
    private static final String[] family = new String[]{"Arial", "Courier", "Georgia", "Helvetica", "Monospaced", "Serif", "SansSerif", "Times New Roman"};
    private static final String[] size = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "28", "34", "40"};
    private static final String[] style = new String[]{"Plain", "Bold", "Italic", "Italic+Bold"};
    private Font font;
    private Color colorText;
    private Color colorBackground;
    private Color colorBorder;
    private Color colorStroke;
    private boolean hasBorder = false;
    private Border border;
    private Border borderButtons = BorderFactory.createLineBorder(Color.BLACK, 1);
    private JLabel labelFamily;
    private JLabel labelSize;
    private JLabel labelStyle;
    private JComboBox<?> comboFamily;
    private JComboBox<?> comboSize;
    private JComboBox<?> comboStyle;
    private JButton buttonTextColor;
    private JButton buttonBckgColor;
    private JButton buttonStrokeColor;
    private JLabel labelTextColor;
    private JLabel labelBckgColor;
    private JLabel labelStrokeColor;
    private JCheckBox checkBorder;
    private JButton buttonBorderColor;
    private JLabel labelBorderColor;
    private JLabel labelPaddingX;
    private JLabel labelPaddingY;
    private JTextField textPaddingX;
    private JTextField textPaddingY;
    private JCheckBox checkAll;
    private JLabel labelPreview;
    private JButton buttonOK;

    public FontDialogCluster(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.initComponents();
        this.addListeners();
        cp.add((Component)this.createPanel(), "Center");
        this.pack();
    }

    private void initComponents() {
        this.font = new Font("SansSeriff", 0, 12);
        this.labelFamily = new JLabel("Family:");
        this.labelSize = new JLabel("Size:");
        this.labelStyle = new JLabel("Style:");
        this.colorText = Color.BLACK;
        this.colorBackground = Color.WHITE;
        this.colorStroke = Color.BLACK;
        this.colorBorder = Color.BLACK;
        this.comboFamily = new JComboBox<String>(family);
        this.comboSize = new JComboBox<String>(size);
        this.comboStyle = new JComboBox<String>(style);
        this.buttonTextColor = new JButton("Text color");
        this.buttonBckgColor = new JButton("Background color");
        this.buttonStrokeColor = new JButton("Stroke color");
        this.labelTextColor = new JLabel("     ");
        this.labelBckgColor = new JLabel("     ");
        this.labelStrokeColor = new JLabel("     ");
        this.checkBorder = new JCheckBox("Border", false);
        this.buttonBorderColor = new JButton("Border color");
        this.labelBorderColor = new JLabel("     ");
        this.border = null;
        this.labelPaddingX = new JLabel("Padding x: ");
        this.labelPaddingY = new JLabel("Padding y: ");
        this.textPaddingX = new JTextField("10", 3);
        this.textPaddingY = new JTextField("10", 3);
        this.checkAll = new JCheckBox("Apply to all clusters?", false);
        this.labelPreview = new JLabel("  Preview  ");
        this.buttonOK = new JButton("OK");
        this.labelTextColor.setSize(20, 20);
        this.labelTextColor.setOpaque(true);
        this.labelTextColor.setBackground(this.colorText);
        this.labelTextColor.setBorder(this.borderButtons);
        this.labelBckgColor.setSize(20, 20);
        this.labelBckgColor.setOpaque(true);
        this.labelBckgColor.setBackground(this.colorBackground);
        this.labelBckgColor.setBorder(this.borderButtons);
        this.labelStrokeColor.setSize(20, 20);
        this.labelStrokeColor.setOpaque(true);
        this.labelStrokeColor.setBackground(this.colorStroke);
        this.labelStrokeColor.setBorder(this.borderButtons);
        this.labelBorderColor.setSize(20, 20);
        this.labelBorderColor.setOpaque(true);
        this.labelBorderColor.setBackground(this.colorBorder);
        this.labelBorderColor.setBorder(this.borderButtons);
        this.labelPreview.setFont(this.font);
        this.labelPreview.setOpaque(true);
        this.labelPreview.setBackground(this.colorBackground);
        this.labelPreview.setForeground(this.colorText);
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        JPanel panelFont = new JPanel();
        JPanel panelColor = new JPanel();
        JPanel panelBorder = new JPanel();
        JPanel panelPadding = new JPanel();
        JPanel panelAll = new JPanel();
        JPanel panelPreview = new JPanel();
        JPanel panelButton = new JPanel();
        JPanel panelOK = new JPanel();
        Border borderBase = BorderFactory.createEtchedBorder();
        TitledBorder borderFont = BorderFactory.createTitledBorder(borderBase, "Fonts");
        TitledBorder borderColor = BorderFactory.createTitledBorder(borderBase, "Colors");
        TitledBorder borderBorder = BorderFactory.createTitledBorder(borderBase, "Border");
        TitledBorder borderPadding = BorderFactory.createTitledBorder(borderBase, "Padding");
        TitledBorder borderPreview = BorderFactory.createTitledBorder(borderBase, "Preview");
        BoxLayout boxLayout = new BoxLayout(panelOK, 1);
        panel.setLayout(new BoxLayout(panel, 1));
        panelFont.setLayout(new FlowLayout(1));
        panelFont.add(this.labelFamily);
        panelFont.add(this.comboFamily);
        panelFont.add(this.labelSize);
        panelFont.add(this.comboSize);
        panelFont.add(this.labelStyle);
        panelFont.add(this.comboStyle);
        panelFont.setBorder(borderFont);
        panelColor.setLayout(new FlowLayout(1));
        panelColor.add(this.buttonTextColor);
        panelColor.add(this.labelTextColor);
        panelColor.add(this.buttonBckgColor);
        panelColor.add(this.labelBckgColor);
        panelColor.add(this.buttonStrokeColor);
        panelColor.add(this.labelStrokeColor);
        panelColor.setBorder(borderColor);
        panelBorder.setLayout(new FlowLayout(1));
        panelBorder.add(this.checkBorder);
        panelBorder.add(this.buttonBorderColor);
        panelBorder.add(this.labelBorderColor);
        panelBorder.setBorder(borderBorder);
        panelPadding.setLayout(new FlowLayout(1));
        panelPadding.add(this.labelPaddingX);
        panelPadding.add(this.textPaddingX);
        panelPadding.add(this.labelPaddingY);
        panelPadding.add(this.textPaddingY);
        panelPadding.setBorder(borderPadding);
        panelAll.setLayout(new FlowLayout(1));
        panelAll.add(this.checkAll);
        panelPreview.setLayout(new FlowLayout(1));
        panelPreview.add(this.labelPreview);
        panelPreview.setBackground(Color.WHITE);
        panelAll.setLayout(new FlowLayout(1));
        panelButton.setLayout(new FlowLayout(1));
        panelAll.add(this.checkAll);
        panelButton.add(this.buttonOK);
        panelOK.setLayout(boxLayout);
        panelOK.add(panelAll);
        panelOK.add(panelButton);
        panelOK.setBorder(BorderFactory.createEtchedBorder());
        panel.add(panelFont);
        panel.add(panelColor);
        panel.add(panelBorder);
        panel.add(panelPadding);
        panel.add(panelOK);
        return panel;
    }

    private void addListeners() {
        this.comboFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                String sel = combo.getSelectedItem().toString();
                FontDialogCluster.this.font = new Font(sel, FontDialogCluster.this.font.getStyle(), FontDialogCluster.this.font.getSize());
                FontDialogCluster.this.updatePreview();
            }
        });
        this.comboSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                int sel = Integer.parseInt(combo.getSelectedItem().toString());
                FontDialogCluster.this.font = new Font(FontDialogCluster.this.font.getFamily(), FontDialogCluster.this.font.getStyle(), sel);
                FontDialogCluster.this.updatePreview();
            }
        });
        this.comboStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                String sel = combo.getSelectedItem().toString();
                int style = 0;
                if (sel.equalsIgnoreCase("plain")) {
                    style = 0;
                } else if (sel.equalsIgnoreCase("bold")) {
                    style = 1;
                } else if (sel.equalsIgnoreCase("italic")) {
                    style = 2;
                } else if (sel.equalsIgnoreCase("italic+bold")) {
                    style = 3;
                }
                FontDialogCluster.this.font = new Font(FontDialogCluster.this.font.getFamily(), style, FontDialogCluster.this.font.getSize());
                FontDialogCluster.this.updatePreview();
            }
        });
        this.buttonTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Color sel;
                FontDialogCluster.this.colorText = sel = JColorChooser.showDialog(null, "Choose", Color.BLACK);
                FontDialogCluster.this.labelTextColor.setBackground(sel);
                FontDialogCluster.this.updatePreview();
            }
        });
        this.buttonBckgColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Color sel;
                FontDialogCluster.this.colorBackground = sel = JColorChooser.showDialog(null, "Choose", Color.WHITE);
                FontDialogCluster.this.labelBckgColor.setBackground(sel);
                FontDialogCluster.this.updatePreview();
            }
        });
        this.buttonStrokeColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color sel;
                FontDialogCluster.this.colorStroke = sel = JColorChooser.showDialog(null, "Choose", Color.WHITE);
                FontDialogCluster.this.labelStrokeColor.setBackground(sel);
                FontDialogCluster.this.updatePreview();
            }
        });
        this.buttonBorderColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Color sel;
                FontDialogCluster.this.colorBorder = sel = JColorChooser.showDialog(null, "Choose", Color.WHITE);
                FontDialogCluster.this.labelBorderColor.setBackground(sel);
                FontDialogCluster.this.updatePreview();
            }
        });
        this.checkBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FontDialogCluster.this.hasBorder = FontDialogCluster.this.checkBorder.isSelected();
                FontDialogCluster.this.border = FontDialogCluster.this.hasBorder ? BorderFactory.createLineBorder(FontDialogCluster.this.colorBorder, 1) : null;
                FontDialogCluster.this.updatePreview();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FontDialogCluster.this.setVisible(false);
            }
        });
    }

    public void showDialog(Font font, Color text, Color stroke, Color background, boolean showBorder, Color cBorder, int paddingX, int paddingY) {
        int i;
        this.font = font;
        String family = font.getFamily();
        for (i = 0; i < this.comboFamily.getItemCount(); ++i) {
            if (this.comboFamily.getItemAt(i).toString().compareToIgnoreCase(family) != 0) continue;
            this.comboFamily.setSelectedIndex(i);
        }
        int size = font.getSize();
        for (i = 0; i < this.comboSize.getItemCount(); ++i) {
            if (Integer.parseInt(this.comboSize.getItemAt(i).toString()) != size) continue;
            this.comboSize.setSelectedIndex(i);
        }
        int style = font.getStyle();
        String style2 = "plain";
        switch (style) {
            case 0: {
                style2 = "plain";
                break;
            }
            case 1: {
                style2 = "bold";
                break;
            }
            case 2: {
                style2 = "italic";
                break;
            }
            case 3: {
                style2 = "italic+bold";
            }
        }
        for (i = 0; i < this.comboStyle.getItemCount(); ++i) {
            if (!this.comboStyle.getItemAt(i).toString().equalsIgnoreCase(style2)) continue;
            this.comboStyle.setSelectedIndex(i);
        }
        this.colorText = text;
        this.labelTextColor.setBackground(this.colorText);
        this.colorBackground = background;
        this.labelBckgColor.setBackground(this.colorBackground);
        this.colorBorder = cBorder;
        this.hasBorder = showBorder;
        this.checkBorder.setSelected(this.hasBorder);
        this.border = this.hasBorder ? BorderFactory.createLineBorder(this.colorBorder, 1) : null;
        this.labelBorderColor.setBackground(this.colorBorder);
        this.textPaddingX.setText(String.valueOf(paddingX));
        this.textPaddingY.setText(String.valueOf(paddingY));
        this.updatePreview();
        this.setVisible(true);
    }

    private void updatePreview() {
        this.labelPreview.setFont(this.font);
        this.labelPreview.setForeground(this.colorText);
        this.labelPreview.setBackground(this.colorBackground);
        this.border = this.checkBorder.isSelected() ? BorderFactory.createLineBorder(this.colorBorder, 1) : null;
        this.labelPreview.setBorder(this.border);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public Color getTextColor() {
        return this.colorText;
    }

    public Color getBackColor() {
        return this.colorBackground;
    }

    public Color getStrokeColor() {
        return this.colorStroke;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public boolean getBorder() {
        return this.border != null;
    }

    public int getPaddingX() {
        int px = 10;
        try {
            px = Integer.parseInt(this.textPaddingX.getText());
        }
        catch (Exception ex) {
            px = 10;
        }
        return px;
    }

    public int getPaddingY() {
        int py = 10;
        try {
            py = Integer.parseInt(this.textPaddingY.getText());
        }
        catch (Exception ex) {
            py = 10;
        }
        return py;
    }

    public boolean getApplyToAll() {
        return this.checkAll.isSelected();
    }
}

