/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class FontDialog2
extends JDialog {
    private static final long serialVersionUID = 7342635254852750586L;
    private static final String[] family = new String[]{"Arial", "Courier", "Georgia", "Helvetica", "Monospaced", "Serif", "SansSerif", "Times New Roman"};
    private static final String[] size = new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "28", "34", "40"};
    private static final String[] style = new String[]{"Plain", "Bold", "Italic", "Italic+Bold"};
    private Font font;
    private Color colorText;
    private Color colorBackground;
    private Color colorBorder;
    private boolean hasBorder = false;
    private Border border;
    private Border borderButtons = BorderFactory.createLineBorder(Color.BLACK, 1);
    private JLabel labelFamily;
    private JLabel labelSize;
    private JLabel labelStyle;
    private JComboBox<?> comboFamily;
    private JComboBox<?> comboSize;
    private JComboBox<?> comboStyle;
    private JButton buttonTextColor;
    private JButton buttonBckgColor;
    private JLabel labelTextColor;
    private JLabel labelBckgColor;
    private JCheckBox checkBorder;
    private JButton buttonBorderColor;
    private JLabel labelBorderColor;
    private JLabel labelPaddingX;
    private JLabel labelPaddingY;
    private JTextField textPaddingX;
    private JTextField textPaddingY;
    private JLabel labelPreview;

    public FontDialog2(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.initComponents();
        this.addListeners();
        cp.add((Component)this.createPanel(), "Center");
        this.pack();
    }

    private void initComponents() {
        this.font = new Font("SansSeriff", 0, 12);
        this.labelFamily = new JLabel("Family");
        this.labelSize = new JLabel("Size");
        this.labelStyle = new JLabel("Style");
        this.colorText = Color.BLACK;
        this.colorBackground = Color.WHITE;
        this.colorBorder = Color.BLACK;
        this.comboFamily = new JComboBox<String>(family);
        this.comboSize = new JComboBox<String>(size);
        this.comboStyle = new JComboBox<String>(style);
        this.buttonTextColor = new JButton("Text color");
        this.buttonBckgColor = new JButton("Background color");
        this.labelTextColor = new JLabel("     ");
        this.labelTextColor.setSize(20, 20);
        this.labelTextColor.setOpaque(true);
        this.labelTextColor.setBackground(this.colorText);
        this.labelTextColor.setBorder(this.borderButtons);
        this.labelBckgColor = new JLabel("     ");
        this.labelBckgColor.setSize(20, 20);
        this.labelBckgColor.setOpaque(true);
        this.labelBckgColor.setBackground(this.colorBackground);
        this.labelBckgColor.setBorder(this.borderButtons);
        this.checkBorder = new JCheckBox("Border", false);
        this.buttonBorderColor = new JButton("Border color");
        this.labelBorderColor = new JLabel("     ");
        this.labelBorderColor.setSize(20, 20);
        this.labelBorderColor.setOpaque(true);
        this.labelBorderColor.setBackground(this.colorBorder);
        this.labelBorderColor.setBorder(this.borderButtons);
        this.border = null;
        this.labelPaddingX = new JLabel("Padding x: ");
        this.labelPaddingY = new JLabel("Padding y: ");
        this.textPaddingX = new JTextField("10", 3);
        this.textPaddingY = new JTextField("10", 3);
        this.labelPreview = new JLabel("  Preview  ");
        this.labelPreview.setFont(this.font);
        this.labelPreview.setOpaque(true);
        this.labelPreview.setBackground(this.colorBackground);
        this.labelPreview.setForeground(this.colorText);
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        JPanel panelFont = new JPanel();
        JPanel panelColor = new JPanel();
        JPanel panelBorder = new JPanel();
        JPanel panelPadding = new JPanel();
        JPanel panelPreview = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panelFont.setLayout(new FlowLayout(1));
        panelFont.add(this.labelFamily);
        panelFont.add(this.comboFamily);
        panelFont.add(this.labelSize);
        panelFont.add(this.comboSize);
        panelFont.add(this.labelStyle);
        panelFont.add(this.comboStyle);
        panelColor.setLayout(new FlowLayout(1));
        panelColor.add(this.buttonTextColor);
        panelColor.add(this.labelTextColor);
        panelColor.add(this.buttonBckgColor);
        panelColor.add(this.labelBckgColor);
        panelBorder.setLayout(new FlowLayout(1));
        panelBorder.add(this.checkBorder);
        panelBorder.add(this.buttonBorderColor);
        panelBorder.add(this.labelBorderColor);
        panelPadding.setLayout(new FlowLayout(1));
        panelPadding.add(this.labelPaddingX);
        panelPadding.add(this.textPaddingX);
        panelPadding.add(this.labelPaddingY);
        panelPadding.add(this.textPaddingY);
        panelPreview.setLayout(new FlowLayout(1));
        panelPreview.add(this.labelPreview);
        panelPreview.setBackground(Color.WHITE);
        panel.add(panelFont);
        panel.add(panelColor);
        panel.add(panelBorder);
        panel.add(panelPadding);
        panel.add(panelPreview);
        return panel;
    }

    private void addListeners() {
        this.comboFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                String sel = combo.getSelectedItem().toString();
                FontDialog2.this.font = new Font(sel, FontDialog2.this.font.getStyle(), FontDialog2.this.font.getSize());
                FontDialog2.this.updatePreview();
            }
        });
        this.comboSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                int sel = Integer.parseInt(combo.getSelectedItem().toString());
                FontDialog2.this.font = new Font(FontDialog2.this.font.getFamily(), FontDialog2.this.font.getStyle(), sel);
                FontDialog2.this.updatePreview();
            }
        });
        this.comboStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                String sel = combo.getSelectedItem().toString();
                int style = 0;
                if (sel.equalsIgnoreCase("plain")) {
                    style = 0;
                } else if (sel.equalsIgnoreCase("bold")) {
                    style = 1;
                } else if (sel.equalsIgnoreCase("italic")) {
                    style = 2;
                } else if (sel.equalsIgnoreCase("italic+bold")) {
                    style = 3;
                }
                FontDialog2.this.font = new Font(FontDialog2.this.font.getFamily(), style, FontDialog2.this.font.getSize());
                FontDialog2.this.updatePreview();
            }
        });
        this.buttonTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Color sel;
                FontDialog2.this.colorText = sel = JColorChooser.showDialog(null, "Choose", Color.BLACK);
                FontDialog2.this.labelTextColor.setBackground(sel);
                FontDialog2.this.updatePreview();
            }
        });
        this.buttonBckgColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Color sel;
                FontDialog2.this.colorBackground = sel = JColorChooser.showDialog(null, "Choose", Color.WHITE);
                FontDialog2.this.labelBckgColor.setBackground(sel);
                FontDialog2.this.updatePreview();
            }
        });
        this.buttonBorderColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Color sel;
                FontDialog2.this.colorBorder = sel = JColorChooser.showDialog(null, "Choose", Color.WHITE);
                FontDialog2.this.labelBorderColor.setBackground(sel);
                FontDialog2.this.updatePreview();
            }
        });
        this.checkBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FontDialog2.this.hasBorder = FontDialog2.this.checkBorder.isSelected();
                FontDialog2.this.border = FontDialog2.this.hasBorder ? BorderFactory.createLineBorder(FontDialog2.this.colorBorder, 1) : null;
                FontDialog2.this.updatePreview();
            }
        });
    }

    public void showDialog(Font font, Color text, Color back, boolean showBorder, Color cBorder, int paddingX, int paddingY) {
        int i;
        this.font = font;
        String family = font.getFamily();
        for (i = 0; i < this.comboFamily.getItemCount(); ++i) {
            if (this.comboFamily.getItemAt(i).toString().compareToIgnoreCase(family) != 0) continue;
            this.comboFamily.setSelectedIndex(i);
        }
        int size = font.getSize();
        for (i = 0; i < this.comboSize.getItemCount(); ++i) {
            if (Integer.parseInt(this.comboSize.getItemAt(i).toString()) != size) continue;
            this.comboSize.setSelectedIndex(i);
        }
        int style = font.getStyle();
        String style2 = "plain";
        switch (style) {
            case 0: {
                style2 = "plain";
                break;
            }
            case 1: {
                style2 = "bold";
                break;
            }
            case 2: {
                style2 = "italic";
                break;
            }
            case 3: {
                style2 = "italic+bold";
            }
        }
        for (i = 0; i < this.comboStyle.getItemCount(); ++i) {
            if (!this.comboStyle.getItemAt(i).toString().equalsIgnoreCase(style2)) continue;
            this.comboStyle.setSelectedIndex(i);
        }
        this.colorText = text;
        this.labelTextColor.setBackground(this.colorText);
        this.colorBackground = back;
        this.labelBckgColor.setBackground(this.colorBackground);
        this.colorBorder = cBorder;
        this.hasBorder = showBorder;
        this.checkBorder.setSelected(this.hasBorder);
        this.border = this.hasBorder ? BorderFactory.createLineBorder(this.colorBorder, 1) : null;
        this.labelBorderColor.setBackground(this.colorBorder);
        this.textPaddingX.setText(String.valueOf(paddingX));
        this.textPaddingY.setText(String.valueOf(paddingY));
        this.updatePreview();
        this.setVisible(true);
    }

    private void updatePreview() {
        this.labelPreview.setFont(this.font);
        this.labelPreview.setForeground(this.colorText);
        this.labelPreview.setBackground(this.colorBackground);
        this.border = this.checkBorder.isSelected() ? BorderFactory.createLineBorder(this.colorBorder, 1) : null;
        this.labelPreview.setBorder(this.border);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public Color getTextColor() {
        return this.colorText;
    }

    public Color getBackColor() {
        return this.colorBackground;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public Border getBorder() {
        return this.border;
    }

    public int getPaddingX() {
        int px = 10;
        try {
            px = Integer.parseInt(this.textPaddingX.getText());
        }
        catch (Exception ex) {
            px = 10;
        }
        return px;
    }

    public int getPaddingY() {
        int py = 10;
        try {
            py = Integer.parseInt(this.textPaddingY.getText());
        }
        catch (Exception ex) {
            py = 10;
        }
        return py;
    }
}

