/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.coords;

import com.biotechvana.phylograph.TreeElement;

public class Slanted {
    private double scaleX = 10.0;
    private double scaleY = 10.0;
    private TreeElement treeList;
    private int highestNodeLevel;
    private int countOtu = 0;
    private double highestChildY = 0.0;
    private double lowestChildY = 10000.0;
    private int childNum = 0;
    private int width;

    public TreeElement getCoords(TreeElement treeList, double maxLenght) {
        this.treeList = treeList;
        this.scaleX = maxLenght;
        this.calcCoords();
        return treeList;
    }

    private void calcCoords() {
        this.highestNodeLevel = 0;
        this.countOtu = 0;
        this.getHighestNodeLevel(this.treeList);
        this.childNum = 0;
        this.getChildNum(this.treeList);
        this.width = (int)((double)this.childNum * this.scaleY) / 2;
        this.calcCoordsOtu(this.treeList);
        this.calcCoordsNode(this.treeList);
    }

    private void getHighestNodeLevel(TreeElement parent) {
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                return;
            }
            if (parent.getLevel() > this.highestNodeLevel) {
                this.highestNodeLevel = parent.getLevel();
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getHighestNodeLevel((TreeElement)parent.get(i));
        }
    }

    private void calcCoordsOtu(TreeElement parent) {
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                parent.setY((double)this.countOtu++ * this.scaleY);
                parent.setX((double)(this.highestNodeLevel + 1) * this.scaleX);
                return;
            }
        } else if (parent.isVisible()) {
            parent.setX(this.width - 5);
            parent.setY((double)this.countOtu++ * this.scaleY);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcCoordsOtu((TreeElement)parent.get(i));
        }
    }

    private void calcCoordsNode(TreeElement parent) {
        if (parent.isNode()) {
            if (parent.isVisible()) {
                parent.setX((double)this.width - this.getNodeX(parent));
                parent.setY(this.getMiddleY(parent));
            } else {
                parent.setX((double)this.width - this.getNodeX(parent));
                return;
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcCoordsNode((TreeElement)parent.get(i));
        }
    }

    private double getMiddleY(TreeElement parent) {
        double middle = 0.0;
        this.highestChildY = 0.0;
        this.lowestChildY = 10000.0;
        this.getChildY(parent);
        middle = (this.highestChildY + this.lowestChildY) / 2.0;
        return middle;
    }

    private void getChildY(TreeElement parent) {
        double parentY = parent.getY();
        if (!parent.isNode() || parent.isNode() && !parent.isVisible()) {
            if (parentY > this.highestChildY) {
                this.highestChildY = parentY;
            }
            if (parentY < this.lowestChildY) {
                this.lowestChildY = parentY;
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            TreeElement child = (TreeElement)parent.get(i);
            if (!parent.isVisible()) continue;
            this.getChildY(child);
        }
    }

    private double getNodeX(TreeElement parent) {
        this.childNum = 0;
        this.getChildNum(parent);
        double x = (double)this.childNum * this.scaleY / 2.0;
        return x;
    }

    private void getChildNum(TreeElement parent) {
        if (parent.isNode() && !parent.isVisible()) {
            ++this.childNum;
            return;
        }
        for (int i = 0; i < parent.size(); ++i) {
            TreeElement child = (TreeElement)parent.get(i);
            if (!child.isNode() && child.isVisible()) {
                ++this.childNum;
            }
            this.getChildNum(child);
        }
    }
}

