/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.coords;

import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.TreeUtils;

public class PolarDist {
    private double rootProportion = 0.01;
    private static double minX = 0.0;
    private static double minY = 0.0;
    private double maxX;
    private double yPosition;
    private double yIncrement;
    private int leafCount = 0;

    TreeElement getCoords(TreeElement treeList) {
        minX = 0.0;
        minY = 0.0;
        TreeUtils treeUtils = new TreeUtils();
        TreeElement root = (TreeElement)treeList.get(0);
        root = root.getFather();
        this.maxX = 0.0;
        this.getMaxXPosition(root, root.getLength());
        double rootHeight = this.maxX;
        double rootLengthProportion = this.rootProportion * rootHeight * 10.0;
        this.yPosition = 0.0;
        treeUtils.setDescendantCount(root);
        this.leafCount = root.getDescendantCount();
        this.yIncrement = 1.0 / (double)this.leafCount;
        this.assignPolarCoordinates(root, rootLengthProportion);
        this.getMinCoords(root);
        this.translateCoords(root);
        return root;
    }

    private void assignPolarCoordinates(TreeElement parent, double xPosition) {
        if (parent.isNode()) {
            TreeElement children;
            int i;
            double yPos = 0.0;
            for (i = 0; i < parent.size(); ++i) {
                children = (TreeElement)parent.get(i);
                double length = children.getLength();
                this.assignPolarCoordinates(children, xPosition + length);
                yPos += children.getY();
            }
            parent.setX(xPosition);
            parent.setY(yPos /= (double)parent.size());
            for (i = 0; i < parent.size(); ++i) {
                children = (TreeElement)parent.get(i);
                this.polarConversion(children);
            }
        } else {
            parent.setX(xPosition);
            parent.setY(this.yPosition);
            this.yPosition += this.yIncrement;
        }
    }

    private void polarConversion(TreeElement parent) {
        double x = parent.getX();
        double y = parent.getY();
        double angle = y * 360.0;
        double r = Math.toRadians(angle);
        double xP = x * Math.cos(r);
        double yP = x * Math.sin(r);
        parent.setX(xP);
        parent.setY(yP);
    }

    private void getMaxXPosition(TreeElement parent, double xPosition) {
        if (parent.isNode()) {
            for (int i = 0; i < parent.size(); ++i) {
                TreeElement children = (TreeElement)parent.get(i);
                double length = children.getLength();
                this.getMaxXPosition(children, xPosition + length);
            }
        } else if (xPosition > this.maxX) {
            this.maxX = xPosition;
        }
    }

    private void getMinCoords(TreeElement parent) {
        double parentX = parent.getX();
        double parentY = parent.getY();
        if (parentX < minX) {
            minX = parentX;
        }
        if (parentY < minY) {
            minY = parentY;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getMinCoords((TreeElement)parent.get(i));
        }
    }

    public static double getMinX() {
        return minX;
    }

    public static double getMinY() {
        return minY;
    }

    private void translateCoords(TreeElement parent) {
        parent.setX(parent.getX() + Math.abs(minX));
        parent.setY(parent.getY() + Math.abs(minY));
        for (int i = 0; i < parent.size(); ++i) {
            this.translateCoords((TreeElement)parent.get(i));
        }
    }
}

