/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.coords;

import com.biotechvana.phylograph.TreeElement;
import java.util.Arrays;

public class Cladogram {
    private double scaleX = 10.0;
    private double scaleY = 10.0;
    private TreeElement treeList;
    private int highestNodeLevel;
    private int countOtu = 0;

    TreeElement getCoords(TreeElement treeList, double maxLength) {
        this.treeList = treeList;
        this.scaleX = maxLength;
        this.calcCoords();
        return treeList;
    }

    private void calcCoords() {
        this.setHighestNodeLevel(0);
        this.countOtu = 0;
        this.getHighestNodeLevel(this.treeList);
        this.calcCoordsTaxa(this.treeList);
        this.calcCoordsNode();
    }

    private void getHighestNodeLevel(TreeElement parent) {
        if (parent.isNode()) {
            boolean visible = parent.isVisible();
            int level = parent.getLevel();
            if (!visible) {
                return;
            }
            if (level > this.getHighestNodeLevel()) {
                this.setHighestNodeLevel(level);
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getHighestNodeLevel((TreeElement)parent.get(i));
        }
    }

    private void calcCoordsTaxa(TreeElement parent) {
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                parent.setY((double)this.countOtu++ * this.scaleY);
                parent.setX((double)(this.getHighestNodeLevel() + 1) * this.scaleX);
                return;
            }
        } else {
            parent.setX((double)(this.getHighestNodeLevel() + 1) * this.scaleX);
            parent.setY((double)this.countOtu++ * this.scaleY);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcCoordsTaxa((TreeElement)parent.get(i));
        }
    }

    private void calcCoordsNode() {
        for (int i = this.getHighestNodeLevel(); i >= 0; --i) {
            this.calcCoordNode2(this.treeList, i);
        }
    }

    private void calcCoordNode2(TreeElement parent, int level) {
        if (parent.isNode() && parent.getLevel() == level && parent.isVisible()) {
            parent.setX((int)((double)parent.getLevel() * this.scaleX));
            double[] childHeights = new double[parent.size()];
            for (int j = 0; j < parent.size(); ++j) {
                childHeights[j] = ((TreeElement)parent.get(j)).getY();
            }
            Arrays.sort(childHeights);
            parent.setYChildLow(childHeights[0]);
            parent.setYChildHigh(childHeights[childHeights.length - 1]);
            parent.setY((childHeights[0] + childHeights[childHeights.length - 1]) / 2.0);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcCoordNode2((TreeElement)parent.get(i), level);
        }
    }

    private int getHighestNodeLevel() {
        return this.highestNodeLevel;
    }

    private void setHighestNodeLevel(int highestNodeLevel) {
        this.highestNodeLevel = highestNodeLevel;
    }
}

