/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.Border;

public class TextLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -8732814510436281441L;
    private int id = 0;
    private int posX = 0;
    private int posY = 0;
    private boolean horizontal = true;
    private boolean transparent = false;
    private String hText = null;
    private String vText = null;
    private Color colorText = Color.BLACK;
    private Color colorBack = Color.WHITE;
    private Color colorBorder = Color.BLACK;
    private Border border = null;
    private InternalF internalF = null;
    private int paddingX = 10;
    private int paddingY = 4;
    private JPopupMenu pop = new JPopupMenu();
    private JMenuItem menuText = new JMenuItem("Change text");
    private JMenuItem menuFont = new JMenuItem("Font & colors");
    private JMenu menuTextDirection = new JMenu("Text alignment");
    private JMenu menuTransparent = new JMenu("Transparent");
    private JMenuItem menuRemove = new JMenuItem("Remove");
    private ButtonGroup groupText = new ButtonGroup();
    private JRadioButtonMenuItem menuRHorizontal = new JRadioButtonMenuItem("Horizontal", true);
    private JRadioButtonMenuItem menuRVertical = new JRadioButtonMenuItem("Vertical", false);
    private ButtonGroup groupTransparent = new ButtonGroup();
    private JRadioButtonMenuItem menuRTransparentYes = new JRadioButtonMenuItem("Yes", false);
    private JRadioButtonMenuItem menuRTransparentNo = new JRadioButtonMenuItem("No", true);

    public TextLabel(InternalF internalF, String text, int posX, int posY) {
        super(text, 0);
        Font font;
        this.setInternalF(internalF);
        this.setId(new Random().nextInt());
        this.setPosX(posX);
        this.setPosY(posY);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        try {
            font = internalF.fontArray[2];
        }
        catch (Exception ex) {
            font = new Font("SansSerif", 1, 12);
        }
        this.setFont(font);
        this.setBounds(this.getPosX(), this.getPosY(), this.getStringWidth(text) + this.getPaddingX() * 2, this.getStringHeight() + this.getPaddingY() * 2);
        this.pop = this.createPop();
        this.setComponentPopupMenu(this.pop);
        this.setHText(text);
        this.setVText(text);
        this.setOpaque(true);
        this.setColorBack(this.colorBack);
        this.setColorText(this.colorText);
        this.setBorder(this.border);
    }

    private JPopupMenu createPop() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.menuText);
        popup.add(this.menuFont);
        popup.add(this.menuTextDirection);
        popup.add(this.menuTransparent);
        popup.add(this.menuRemove);
        this.menuTextDirection.add(this.menuRHorizontal);
        this.menuTextDirection.add(this.menuRVertical);
        this.groupText.add(this.menuRHorizontal);
        this.groupText.add(this.menuRVertical);
        this.groupTransparent.add(this.menuRTransparentYes);
        this.groupTransparent.add(this.menuRTransparentNo);
        this.menuTransparent.add(this.menuRTransparentYes);
        this.menuTransparent.add(this.menuRTransparentNo);
        this.menuText.addActionListener(new TextListener());
        this.menuRemove.addActionListener(new RemoveListener());
        this.menuFont.addActionListener(new FontListener());
        this.menuRHorizontal.addActionListener(new DirectionListener());
        this.menuRVertical.addActionListener(new DirectionListener());
        this.menuRTransparentYes.addActionListener(new TransparencyListener());
        this.menuRTransparentNo.addActionListener(new TransparencyListener());
        return popup;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.pop.show(this, me.getX(), me.getY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mme) {
        this.setPosX(this.getPosX() + mme.getX() - this.getWidth() / 2);
        this.setPosY(this.getPosY() + mme.getY() - this.getHeight() / 2);
        this.setLocation(this.getPosX(), this.getPosY());
    }

    @Override
    public void mouseMoved(MouseEvent mme) {
    }

    private void changeText() {
        String res = JOptionPane.showInputDialog(this, "Enter new text: ", this.getHText());
        if (res == null || res == "" || res.length() == 0) {
            return;
        }
        this.setHText(res);
        this.setVText(res);
        if (this.isHorizontal()) {
            this.setHorizontal(false);
        } else {
            this.setHorizontal(true);
        }
        this.changeDirection();
    }

    private void removeLabel() {
        this.setEnabled(false);
        this.getInternalF().getPanelTree().remove(this);
        this.removeLabelFromList(this.getInternalF().getLabelList(), this.id);
        this.getInternalF().updatePanel();
    }

    private void removeLabelFromList(List<TextLabel> textLabelList, int id) {
        for (int i = 0; i < textLabelList.size(); ++i) {
            TextLabel label = textLabelList.get(i);
            if (label.getId() != id) continue;
            textLabelList.remove(i);
        }
    }

    private void changeDirection() {
        if (this.menuRVertical.isSelected() && this.isHorizontal()) {
            this.setText(this.getVText());
            int charHeight = this.getStringHeight() * (this.getHText().length() + 1);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(4);
            this.setBounds(this.getX() - 2, this.getY(), this.getStringHeight(), charHeight);
            this.horizontal = false;
        }
        if (this.menuRHorizontal.isSelected() && !this.isHorizontal()) {
            this.setText(this.getHText());
            this.setBounds(this.getX(), this.getY(), this.getStringWidth(this.getHText()) + 8, this.getStringHeight() + 2);
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(0);
            this.horizontal = true;
        }
    }

    private void setVText(String input) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><center>");
        for (int i = 0; i < input.length(); ++i) {
            sb.append(input.charAt(i) + "<br>");
        }
        sb.append("</center></html>");
        this.vText = sb.toString();
    }

    private void changeFont() {
        this.getInternalF().getFontDialog().showDialog(this.getFont(), this.getColorText(), this.getColorBack(), this.hasBorder(), this.getColorBorder(), this.getPaddingX(), this.getPaddingY());
        this.setFont(this.getInternalF().getFontDialog().getFont());
        this.setColorText(this.getInternalF().getFontDialog().getTextColor());
        this.setColorBack(this.getInternalF().getFontDialog().getBackColor());
        this.setColorBorder(this.getInternalF().getFontDialog().getColorBorder());
        this.setBorder(this.getInternalF().getFontDialog().getBorder());
        this.setFont(this.getInternalF().getFontDialog().getFont());
        this.setPaddingX(this.getInternalF().getFontDialog().getPaddingX());
        this.setPaddingY(this.getInternalF().getFontDialog().getPaddingY());
        this.setForeground(this.getColorText());
        this.setBackground(this.getColorBack());
        this.setBorder(this.getBorder());
        this.setBounds(this.getX(), this.getY(), this.getStringWidth(this.getHText()) + this.getPaddingX() * 2, this.getStringHeight() + this.getPaddingY() * 2);
    }

    public int getId() {
        return this.id;
    }

    public int getStringWidth(String text) {
        return this.getFontMetrics(this.getFont()).stringWidth(text);
    }

    public int getStringHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public String getHText() {
        return this.hText;
    }

    public boolean hasBorder() {
        return this.border != null;
    }

    public void setBorder(boolean option) {
        if (!option) {
            this.setBorder(null);
        } else {
            this.border = BorderFactory.createLineBorder(this.colorBorder);
            this.setBorder(this.border);
        }
    }

    public void setPaddingX(int paddingX) {
        this.paddingX = paddingX;
        this.setBounds(this.getX(), this.getY(), this.getStringWidth(this.getHText()) + this.getPaddingX() * 2, this.getStringHeight() + this.getPaddingY() * 2);
    }

    public void setPaddingY(int paddingY) {
        this.paddingY = paddingY;
        this.setBounds(this.getX(), this.getY(), this.getStringWidth(this.getHText()) + this.getPaddingX() * 2, this.getStringHeight() + this.getPaddingY() * 2);
    }

    public void changeFont(Font newFont) {
        this.setFont(newFont);
        this.setBounds(this.getX(), this.getY() - this.getStringHeight() / 2, this.getStringWidth(this.getHText()) + this.getPaddingX(), this.getStringHeight() + this.getPaddingY());
    }

    public void changeTransparency() {
        if (!this.transparent && this.menuRTransparentYes.isSelected()) {
            this.setOpaque(false);
            this.transparent = true;
        }
        if (this.transparent && this.menuRTransparentNo.isSelected()) {
            this.setOpaque(true);
            this.transparent = false;
        }
        this.repaint();
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
    }

    private InternalF getInternalF() {
        return this.internalF;
    }

    private void setInternalF(InternalF internalF) {
        this.internalF = internalF;
    }

    private void setId(int id) {
        this.id = id;
    }

    private int getPosX() {
        return this.posX;
    }

    private int getPosY() {
        return this.posY;
    }

    private void setPosX(int posX) {
        this.posX = posX;
    }

    private void setPosY(int posY) {
        this.posY = posY;
    }

    private void setHText(String text) {
        this.hText = text;
    }

    private String getVText() {
        return this.vText;
    }

    public Color getColorBack() {
        return this.colorBack;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public Color getColorText() {
        return this.colorText;
    }

    public void setColorBack(Color colorBack) {
        this.colorBack = colorBack;
        this.setBackground(colorBack);
    }

    public void setColorBorder(Color colorBorder) {
        this.colorBorder = colorBorder;
        this.border = BorderFactory.createLineBorder(colorBorder);
    }

    public void setColorText(Color colorText) {
        this.colorText = colorText;
        this.setForeground(colorText);
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        if (horizontal) {
            this.menuRHorizontal.setSelected(true);
            this.horizontal = false;
            this.changeDirection();
        } else {
            this.menuRVertical.setSelected(true);
            this.horizontal = true;
            this.changeDirection();
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        if (transparent) {
            this.menuRTransparentYes.setSelected(true);
            this.setOpaque(false);
        } else {
            this.menuRTransparentNo.setSelected(true);
            this.setOpaque(true);
        }
    }

    class TextListener
    implements ActionListener {
        TextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TextLabel.this.changeText();
        }
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TextLabel.this.removeLabel();
        }
    }

    class FontListener
    implements ActionListener {
        FontListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TextLabel.this.changeFont();
        }
    }

    class DirectionListener
    implements ActionListener {
        DirectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TextLabel.this.changeDirection();
        }
    }

    class TransparencyListener
    implements ActionListener {
        TransparencyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TextLabel.this.changeTransparency();
        }
    }
}

