/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Scale
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 7886706311267553781L;
    private Color colorScale = Color.BLACK;
    private double scaleValue = 0.0;
    private int posX = 0;
    private int posY = 0;
    private JPopupMenu popup = null;
    private InternalF internalF = null;
    private int paddingX = 0;
    private int paddingY = 0;
    private int mult = 1;

    public Scale(InternalF internalF, double value, int posX, int posY) {
        super(String.valueOf(value), 0);
        this.setInternalF(internalF);
        this.setScaleValue(value);
        this.setPosX(posX);
        this.setPosY(posY);
        if (this.getScaleValue() == 100.0) {
            this.setText("100");
        } else if (this.getScaleValue() == 10.0) {
            this.setText("10");
        } else if (this.getScaleValue() == 1.0) {
            this.setText("1");
        }
        this.mult = value == 0.01 ? 1000 : (value == 0.1 ? 100 : (value == 1.0 ? 10 : 1));
        this.setFont(new Font("SansSerif", 0, 10));
        if (this.getStringWidth() > this.getWidthLine()) {
            this.setBounds(this.getPosX(), this.getPosY(), this.getStringWidth(), this.getStringHeight());
        } else {
            this.setBounds(this.getPosX(), this.getPosY(), this.getWidthLine(), this.getStringHeight());
        }
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.popup = this.createPopup();
        this.setComponentPopupMenu(this.popup);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setVisible(true);
        g2.setColor(this.getColorScale());
        if (this.getStringWidth() > this.getWidthLine()) {
            this.setBounds(this.getX(), this.getY(), this.getStringWidth(), this.getStringHeight());
        } else {
            this.setBounds(this.getX(), this.getY(), this.getWidthLine(), this.getStringHeight());
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidthLine(), this.getHeight() - 1);
    }

    private JPopupMenu createPopup() {
        JPopupMenu pop = new JPopupMenu();
        JMenuItem menuFont = new JMenuItem("Change font");
        JMenu menuValue = new JMenu("Change value");
        JMenuItem menuValue1 = new JMenuItem("0.1");
        JMenuItem menuValue2 = new JMenuItem("10");
        JMenuItem menuValue3 = new JMenuItem("100");
        pop.add(menuFont);
        menuValue.add(menuValue1);
        menuValue.add(menuValue2);
        menuValue.add(menuValue3);
        menuFont.addActionListener(new FontListener());
        ValueListener valueListener = new ValueListener();
        menuValue1.addActionListener(valueListener);
        menuValue2.addActionListener(valueListener);
        menuValue3.addActionListener(valueListener);
        return pop;
    }

    @Override
    public void mouseDragged(MouseEvent mme) {
        this.setPosX(this.getX() + mme.getX() - this.getWidth() / 2);
        this.setPosY(this.getY() + mme.getY() - this.getHeight() / 2);
        this.setLocation(this.getPosX(), this.getPosY());
    }

    @Override
    public void mouseMoved(MouseEvent mme) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.getInternalF().moveElements(this.getInternalF().getTreeList());
        this.repaint();
        if (me.isPopupTrigger()) {
            this.popup.show(this, me.getX(), me.getY());
        }
    }

    private void changeFont() {
        this.getInternalF().getFontDialog().showDialog(this.getFont(), this.getColorScale(), Color.WHITE, false, Color.WHITE, this.getPaddingX(), this.getPaddingY());
        this.setFont(this.getInternalF().getFontDialog().getFont());
        this.setColorScale(this.getInternalF().getFontDialog().getTextColor());
        this.setForeground(this.getColorScale());
        this.repaint();
    }

    private void changeValue(String value) {
        if (value.equals("0.1")) {
            this.setScaleValue(100.0);
        } else if (value.equals("10")) {
            this.setScaleValue(10.0);
        } else if (value.equals("100")) {
            this.setScaleValue(100.0);
        }
        this.setText(String.valueOf(this.getScaleValue()));
        this.repaint();
    }

    public double getScaleValue() {
        return this.scaleValue;
    }

    public int getTextWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(String.valueOf(this.getScaleValue()));
    }

    public Color getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(Color colorScale) {
        this.colorScale = colorScale;
    }

    private InternalF getInternalF() {
        return this.internalF;
    }

    private void setInternalF(InternalF internalF) {
        this.internalF = internalF;
    }

    public void setScaleValue(double value) {
        this.scaleValue = value;
    }

    private int getPosX() {
        return this.posX;
    }

    private int getPosY() {
        return this.posY;
    }

    private void setPosX(int posX) {
        this.posX = posX;
    }

    private void setPosY(int posY) {
        this.posY = posY;
    }

    private int getPaddingX() {
        return this.paddingX;
    }

    private int getPaddingY() {
        return this.paddingY;
    }

    private int getWidthLine() {
        return (int)(this.getScaleValue() * this.internalF.getScaleFactorX() * (double)this.mult);
    }

    private int getStringWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(String.valueOf(this.getScaleValue()));
    }

    private int getStringHeight() {
        return this.getFontMetrics(this.getFont()).getHeight() + 6;
    }

    class FontListener
    implements ActionListener {
        FontListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Scale.this.changeFont();
        }
    }

    class ValueListener
    implements ActionListener {
        ValueListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Scale.this.changeValue(ae.getActionCommand());
        }
    }
}

