/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.components.Node;
import com.biotechvana.phylograph.dialogs.FontDialogOtu;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class Otu
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 3371673939303495722L;
    private InternalF internalF;
    private int id = 0;
    private long id2 = -1L;
    private int level = 0;
    private JPopupMenu popup;
    private JMenuItem menuText;
    private JMenuItem menuFont;
    private JMenuItem menuLink;
    private JMenuItem menuRoot;
    private JMenuItem menuRestore;
    private Color colorTextLink = Color.BLUE;
    private Color colorBorder = Color.BLACK;
    private String link = null;
    private Node father;
    private double treeX;
    private double treeY;
    private double length;
    private int paddingX = 10;
    private int paddingY = 10;

    public Otu(InternalF internalF, int id, String text, int level) {
        this.setInternalF(internalF);
        this.setId(id);
        this.setLevel(level);
        this.setText(text);
        this.setToolTipText(this.getText());
        this.setFont(internalF.fontArray[0]);
        this.setOpaque(false);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.popup = this.createPopupMenu();
        this.add(this.popup);
        this.setComponentPopupMenu(this.popup);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.menuRoot = new JMenuItem("Root");
        this.menuRestore = new JMenuItem("Unroot");
        this.menuText = new JMenuItem("Change text");
        this.menuFont = new JMenuItem("Font & colors");
        this.menuLink = new JMenuItem("Link");
        popup.add(this.menuRoot);
        popup.add(this.menuRestore);
        popup.add(this.menuText);
        popup.add(this.menuFont);
        popup.add(this.menuLink);
        this.menuText.addActionListener(new TextListener());
        this.menuRoot.addActionListener(new RootListener());
        this.menuFont.addActionListener(new FontListener());
        this.menuLink.addActionListener(new LinkListener());
        this.menuRestore.addActionListener(new RestoreListener());
        return popup;
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.internalF.isInverted()) {
            return;
        }
        if (this.level == 1) {
            this.popup = this.createPopupMenu();
            this.popup.remove(this.menuRoot);
        }
        if (this.internalF.isRooted()) {
            this.popup.remove(this.menuRoot);
        } else {
            this.popup.remove(this.menuRestore);
        }
        if (this.internalF.getTreeView().equalsIgnoreCase("unrooted")) {
            this.popup.remove(this.menuRoot);
            this.popup.remove(this.menuRestore);
        }
        if (me.isPopupTrigger()) {
            this.popup.show(this, me.getX(), me.getY());
        }
        if (me.getModifiersEx() == 2) {
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        if (!this.getInternalF().getTreeView().equalsIgnoreCase("unrooted")) {
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    public void changeText() {
        String res = null;
        while (res == null) {
            res = JOptionPane.showInputDialog(this, "New text:", this.getText());
        }
        this.getInternalF().getTreeUtils().changeOtuAttribute(this.getInternalF().getTreeList(), this.getId(), "text", res);
        this.setText(res);
        this.setBounds(this.getX(), this.getY(), this.getStringWidth(), this.getStringHeight());
        this.setForeground(this.getForeground());
        this.getInternalF().updatePanel();
    }

    public void rootOutgroup() {
        if (this.getInternalF().getOrginalRootId2() == this.id2) {
            this.unrootOutgroup();
            return;
        }
        TreeElement auxList = this.getInternalF().getAuxList();
        if (this.getInternalF().isRooted()) {
            this.getInternalF().setTreeList(this.getInternalF().getAuxList());
            this.getInternalF().setRooted(false);
        }
        this.getInternalF().setAuxList(this.getInternalF().getTreeUtils().copyTree(this.getInternalF().getTreeList()));
        this.getInternalF().setTreeList(this.getInternalF().getTreeUtils().rootOutgroup(this.getInternalF().getTreeList(), this.id2, false));
        this.getInternalF().setTreeList(this.getInternalF().getTreeGram().getCoords(this.getInternalF().getTreeList(), this.getInternalF().getTreeView(), this.internalF.getMaxLength(), this.internalF.negativeType));
        this.getInternalF().getPanelTree().setTreeList(this.getInternalF().getTreeList());
        this.getInternalF().createElements();
        this.getInternalF().setRooted(true);
    }

    public void unrootOutgroup() {
        this.getInternalF().setAuxList(null);
        this.getInternalF().setTreeList(this.getInternalF().getOriginalTreeList());
        this.getInternalF().setTreeList(this.getInternalF().getTreeGram().getCoords(this.getInternalF().getTreeList(), this.getInternalF().getTreeView(), this.internalF.getMaxLength(), this.internalF.negativeType));
        this.getInternalF().getPanelTree().setTreeList(this.getInternalF().getTreeList());
        this.getInternalF().createElements();
        this.getInternalF().setRooted(false);
        if (this.getInternalF().getTreeView().equalsIgnoreCase("slanted")) {
            this.getInternalF().changeTreeType("cladogram");
            this.getInternalF().changeTreeType("slanted");
        }
    }

    public void changeFont() {
        FontDialogOtu fontDialogotu = this.getInternalF().getFontDialogOtu();
        fontDialogotu.showDialog(this.getFont(), this.getForeground());
        this.setFont(fontDialogotu.getFont());
        this.setForeground(fontDialogotu.getTextColor());
        this.setBounds(this.getX(), this.getY(), this.getStringWidth(), this.getStringHeight());
        this.getInternalF().moveOtu(this.getInternalF().getTreeList());
    }

    public void changeFont(Font font) {
        this.setFont(font);
        this.setForeground(this.getForeground());
        this.setBackground(this.getBackground());
        this.setBorder(null);
        this.setBounds(this.getX(), this.getY(), this.getStringWidth(), this.getStringHeight());
        this.getInternalF().moveOtu(this.getInternalF().getTreeList());
    }

    private Color getColorBorder() {
        return this.colorBorder;
    }

    public Color getColorTextLink() {
        return this.colorTextLink;
    }

    public Node getFather() {
        return this.father;
    }

    public int getId() {
        return this.id;
    }

    public InternalF getInternalF() {
        return this.internalF;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLink() {
        return this.link;
    }

    private int getPaddingX() {
        return this.paddingX;
    }

    private int getPaddingY() {
        return this.paddingY;
    }

    public double getLength() {
        return this.length;
    }

    public double getTreeX() {
        return this.treeX;
    }

    public double getTreeY() {
        return this.treeY;
    }

    public void setColorTextLink(Color color) {
        this.colorTextLink = color;
        if (this.link != null) {
            this.setForeground(color);
        }
    }

    public void setFather(Node father) {
        this.father = father;
    }

    private void setLevel(int level) {
        this.level = level;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setLink() {
        String res = JOptionPane.showInputDialog("Link: ", (Object)this.getLink());
        if (res != null) {
            this.setLink(res);
        }
        if (this.getLink() != null && this.getLink().length() > 0) {
            this.setForeground(this.getColorTextLink());
            this.getInternalF().getTreeUtils().changeOtuAttribute(this.getInternalF().getTreeList(), this.getId(), "link", this.getLink());
        } else {
            this.setForeground(this.getForeground());
            this.getInternalF().getTreeUtils().changeOtuAttribute(this.getInternalF().getTreeList(), this.getId(), "link", null);
        }
    }

    public void setLink(String link) {
        this.link = link;
    }

    private void setId(int id) {
        this.id = id;
    }

    public void setInternalF(InternalF internalF) {
        this.internalF = internalF;
    }

    public void setTreeY(double treeY) {
        this.treeY = treeY;
    }

    public void setTreeX(double treeX) {
        this.treeX = treeX;
    }

    private int getStringWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 2;
    }

    public int getStringHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    public long getId2() {
        return this.id2;
    }

    public void setId2(long id2) {
        this.id2 = id2;
    }

    class TextListener
    implements ActionListener {
        TextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Otu.this.changeText();
        }
    }

    class RootListener
    implements ActionListener {
        RootListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Otu.this.rootOutgroup();
        }
    }

    class FontListener
    implements ActionListener {
        FontListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Otu.this.changeFont();
        }
    }

    class LinkListener
    implements ActionListener {
        LinkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Otu.this.setLink();
        }
    }

    class RestoreListener
    implements ActionListener {
        RestoreListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Otu.this.unrootOutgroup();
        }
    }

    class UnrootListener
    implements ActionListener {
        UnrootListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Otu.this.unrootOutgroup();
        }
    }
}

