/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Hand
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -1338948911247153950L;
    private int id = 0;
    private int posX;
    private int posY;
    private JPopupMenu pop = new JPopupMenu();
    private ImageIcon icon = new ImageIcon(this.getToolkit().getImage("images/hand_left.gif"));
    private InternalF internalF;

    public Hand(InternalF internalF, int id, int x, int y) {
        super("", 0);
        this.internalF = internalF;
        this.id = id;
        this.posX = x;
        this.posY = y;
        this.pop = this.createPop();
        this.setComponentPopupMenu(this.pop);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setIcon(this.icon);
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
    }

    private JPopupMenu createPop() {
        JPopupMenu pop = new JPopupMenu();
        JMenuItem menuRemove = new JMenuItem("Remove");
        pop.add(menuRemove);
        menuRemove.addActionListener(new RemoveListener());
        return pop;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.pop.show(this, me.getX(), me.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mme) {
    }

    @Override
    public void mouseDragged(MouseEvent mme) {
        this.posX += mme.getX() - this.getWidth() / 2;
        this.posY += mme.getY() - this.getHeight() / 2;
        this.setLocation(this.posX, this.posY);
    }

    public void removeHand() {
        this.internalF.getPanelTree().remove(this);
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Hand.this.removeHand();
        }
    }
}

