/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Bracket
extends JButton
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -6937280119474734218L;
    private int id = 0;
    private int posX;
    private int posY;
    private JPopupMenu pop = new JPopupMenu();
    private int RIGHT_SHIFT_MASK = 1088;
    private int initialX;
    private int initialY;
    private int initialWidth;
    private int initialHeight;
    private boolean inverted = false;
    private Color colorLine = Color.BLACK;
    private InternalF internalF;

    public Bracket(InternalF internalF, int x, int y, int w, int h) {
        this.setInternalF(internalF);
        this.setId(new Random().nextInt());
        this.setPosX(x);
        this.setPosY(y);
        this.pop = this.createPop();
        this.setComponentPopupMenu(this.pop);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setContentAreaFilled(false);
        this.setEnabled(false);
        this.setBorderPainted(false);
        this.setFocusable(false);
        this.setBounds(this.getPosX(), this.getPosY(), w, h);
        this.setToolTipText("<html><center>Press <b>Shift</b> and<br> drag mouse to resize</center></html>");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getColorLine());
        if (this.isInverted()) {
            g2.drawLine(0, 0, this.getWidth(), 0);
            g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g2.drawLine(0, 0, 0, this.getHeight());
        } else {
            g2.drawLine(0, 0, this.getWidth(), 0);
            g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g2.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
        }
    }

    private JPopupMenu createPop() {
        JPopupMenu pop = new JPopupMenu();
        JMenuItem menuColor = new JMenuItem("Color");
        JMenuItem menuRemove = new JMenuItem("Remove");
        pop.add(menuColor);
        pop.add(menuRemove);
        menuRemove.addActionListener(new RemoveListener());
        menuColor.addActionListener(new ColorListener());
        return pop;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if ((me.getModifiersEx() & this.RIGHT_SHIFT_MASK) == this.RIGHT_SHIFT_MASK) {
            this.setInitialX(me.getX());
            this.setInitialY(me.getY());
            this.setInitialWidth(this.getWidth());
            this.setInitialHeight(this.getHeight());
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.pop.show(this, me.getX(), me.getY());
        }
        this.internalF.updatePanel();
    }

    @Override
    public void mouseMoved(MouseEvent mme) {
    }

    @Override
    public void mouseDragged(MouseEvent mme) {
        if ((mme.getModifiersEx() & this.RIGHT_SHIFT_MASK) == this.RIGHT_SHIFT_MASK) {
            if (this.getInitialWidth() + (mme.getX() - this.getInitialX()) > 0 && this.getInitialHeight() + (mme.getY() - this.getInitialY()) > 0) {
                this.setBounds(this.getX(), this.getY(), this.getInitialWidth() + (mme.getX() - this.getInitialX()), this.getInitialHeight() + (mme.getY() - this.getInitialY()));
            }
        } else {
            this.setPosX(this.getPosX() + (mme.getX() - this.getWidth() / 2));
            this.setPosY(this.getPosY() + (mme.getY() - this.getHeight() / 2));
            this.setLocation(this.getPosX(), this.getPosY());
        }
    }

    public void removeBracket() {
        this.getInternalF().getPanelTree().remove(this);
        this.removeBracketFromList(this.getInternalF().getBracketList(), this.id);
        this.getInternalF().updatePanel();
    }

    private void removeBracketFromList(List<Bracket> bracketList, int id) {
        for (int i = 0; i < bracketList.size(); ++i) {
            Bracket bracket = bracketList.get(i);
            if (bracket.getId() != id) continue;
            bracketList.remove(i);
        }
    }

    public void changeColor() {
        this.setColorLine(JColorChooser.showDialog(null, "Choose color for bracket", this.getColorLine()));
        this.repaint();
    }

    public int getId() {
        return this.id;
    }

    public Color getColorLine() {
        return this.colorLine;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public void setColorLine(Color colorLine) {
        this.colorLine = colorLine;
    }

    private InternalF getInternalF() {
        return this.internalF;
    }

    private void setInternalF(InternalF internalF) {
        this.internalF = internalF;
    }

    private void setId(int id) {
        this.id = id;
    }

    private int getPosX() {
        return this.posX;
    }

    private void setPosX(int posX) {
        this.posX = posX;
    }

    private int getPosY() {
        return this.posY;
    }

    private void setPosY(int posY) {
        this.posY = posY;
    }

    private boolean isInverted() {
        return this.inverted;
    }

    private int getInitialHeight() {
        return this.initialHeight;
    }

    private int getInitialWidth() {
        return this.initialWidth;
    }

    private int getInitialX() {
        return this.initialX;
    }

    private int getInitialY() {
        return this.initialY;
    }

    private void setInitialHeight(int initialHeight) {
        this.initialHeight = initialHeight;
    }

    private void setInitialWidth(int initialWidth) {
        this.initialWidth = initialWidth;
    }

    private void setInitialX(int initialX) {
        this.initialX = initialX;
    }

    private void setInitialY(int initialY) {
        this.initialY = initialY;
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Bracket.this.removeBracket();
        }
    }

    class ColorListener
    implements ActionListener {
        ColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Bracket.this.changeColor();
        }
    }
}

