/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.ClustalToNewick;
import com.biotechvana.phylograph.JsonToNewick;
import com.biotechvana.phylograph.NexusToNewick;
import com.biotechvana.phylograph.TreeFormat;
import com.biotechvana.phylograph.utils.FileToString;
import java.io.File;

public class ParseTreeFile {
    private FileToString fts = new FileToString();
    private String output = null;

    public ParseTreeFile(File file) {
        String input = this.fts.getString(file.getAbsoluteFile());
        TreeFormat ttype = new TreeFormat(input);
        String tipo = ttype.getType();
        if (tipo.equalsIgnoreCase("nexus")) {
            NexusToNewick ntn = new NexusToNewick(input);
            this.output = ntn.getNewick();
        } else if (tipo.equalsIgnoreCase("json")) {
            JsonToNewick jtn = new JsonToNewick(input);
            this.output = jtn.getNewick();
        } else if (tipo.equalsIgnoreCase("clustal")) {
            ClustalToNewick ctn = new ClustalToNewick(input);
            this.output = ctn.getNewick();
        } else {
            this.output = input;
        }
    }

    public ParseTreeFile(String input) {
        TreeFormat ttype = new TreeFormat(input);
        String tipo = ttype.getType();
        if (tipo.equalsIgnoreCase("nexus")) {
            NexusToNewick ntn = new NexusToNewick(input);
            this.output = ntn.getNewick();
        } else if (tipo.equalsIgnoreCase("json")) {
            JsonToNewick jtn = new JsonToNewick(input);
            this.output = jtn.getNewick();
        } else if (tipo.equalsIgnoreCase("clustal")) {
            ClustalToNewick ctn = new ClustalToNewick(input);
            this.output = ctn.getNewick();
        } else {
            this.output = input;
        }
    }

    public String getNewick() {
        return this.output;
    }
}

