/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.coords.Polar;
import com.biotechvana.phylograph.coords.PolarDist;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class PanelTree
extends JPanel {
    private static final long serialVersionUID = 3651848493857872787L;
    private TreeElement treeList = null;
    private double scaleFactorX = 1.0;
    private double scaleFactorY = 1.0;
    private int marginX = 20;
    private int marginY = 20;
    public BufferedImage bimage;
    private InternalF intf;
    private String treeView;
    private double angularRange = 360.0;

    public PanelTree(TreeElement treeList, InternalF intf, String treeView) {
        this.treeList = treeList;
        this.intf = intf;
        this.treeView = treeView;
        this.setPreferredSize(new Dimension(500, 500));
        this.setBackground(Color.WHITE);
        this.setLayout(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.treeList != null) {
            if (this.bimage != null) {
                g2.drawImage(this.bimage, null, 0, 0);
            } else {
                int imageWidth = (int)this.intf.getDim().getWidth();
                int imageHeight = (int)this.intf.getDim().getHeight();
                this.bimage = (BufferedImage)this.createImage(imageWidth, imageHeight);
                Graphics2D gc = this.bimage.createGraphics();
                gc.setColor(Color.WHITE);
                gc.fillRect(0, 0, imageWidth, imageHeight);
                gc.setColor(Color.BLACK);
                if (this.treeView.equalsIgnoreCase("cladogram") || this.treeView.equalsIgnoreCase("phylogram")) {
                    this.paintTreeRectangular(gc, this.treeList);
                } else if (this.treeView.equalsIgnoreCase("slanted")) {
                    this.paintTreeSlanted(gc, this.treeList);
                } else if (this.treeView.equalsIgnoreCase("unrooted")) {
                    this.paintTreeUnrooted(gc, this.treeList);
                } else if (this.treeView.equalsIgnoreCase("polarDist") || this.treeView.equalsIgnoreCase("polar")) {
                    this.paintTreePolar(gc, this.treeList, this.treeView);
                } else {
                    this.paintTreeRectangular(gc, this.treeList);
                }
                g2.drawImage(this.bimage, null, 0, 0);
            }
        }
    }

    private void paintTreeRectangular(Graphics2D g2, TreeElement parent) {
        int xFather;
        Color colorFather;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color colorParent = parent.getColorLine();
        boolean colorEqual = true;
        int xParent = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
        int yParent = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
        int yChildHigh = (int)(parent.getYChildHigh() * this.scaleFactorY) + this.marginY;
        int yChildLow = (int)(parent.getYChildLow() * this.scaleFactorY) + this.marginY;
        try {
            colorFather = parent.getFather().getColorLine();
        }
        catch (Exception ex) {
            colorFather = colorParent;
        }
        if (colorParent != colorFather) {
            colorEqual = false;
        }
        g2.setColor(parent.getColorLine());
        try {
            xFather = (int)(parent.getFather().getX() * this.scaleFactorX) + this.marginX;
        }
        catch (Exception ex) {
            xFather = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
        }
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                g2.drawLine(xParent, yParent, xFather, yParent);
                return;
            }
            if (!colorEqual) {
                g2.setColor(colorFather);
            }
            g2.drawLine(xParent, yParent, xFather, yParent);
            if (!colorEqual) {
                g2.setColor(colorParent);
            }
            g2.drawLine(xParent, yChildHigh, xParent, yChildLow);
        } else {
            g2.drawLine(xParent, yParent, xFather, yParent);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.paintTreeRectangular(g2, (TreeElement)parent.get(i));
        }
    }

    private void paintTreeSlanted(Graphics2D g2, TreeElement parent) {
        int yFather;
        int xFather;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(parent.getColorLine());
        int xParent = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
        int yParent = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
        try {
            xFather = (int)(parent.getFather().getX() * this.scaleFactorX) + this.marginX;
        }
        catch (Exception ex) {
            xFather = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
        }
        try {
            yFather = (int)(parent.getFather().getY() * this.scaleFactorY) + this.marginY;
        }
        catch (Exception ex) {
            yFather = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
        }
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                g2.drawLine(xParent, yParent, xFather, yFather);
                return;
            }
            g2.drawLine(xParent, yParent, xFather, yFather);
        } else {
            g2.drawLine(xParent, yParent, xFather, yFather);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.paintTreeSlanted(g2, (TreeElement)parent.get(i));
        }
    }

    private void paintTreeUnrooted(Graphics2D g2, TreeElement parent) {
        int yFather;
        int xFather;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(parent.getColorLine());
        int xParent = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
        int yParent = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
        try {
            xFather = (int)(parent.getFather().getX() * this.scaleFactorX) + this.marginX;
        }
        catch (Exception ex) {
            xFather = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
        }
        try {
            yFather = (int)(parent.getFather().getY() * this.scaleFactorY) + this.marginY;
        }
        catch (Exception ex) {
            yFather = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
        }
        if (parent.isNode()) {
            if (!parent.isRoot()) {
                g2.drawLine(xParent, yParent, xFather, yFather);
            }
            g2.setColor(Color.BLACK);
        } else {
            g2.drawLine(xParent, yParent, xFather, yFather);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.paintTreeUnrooted(g2, (TreeElement)parent.get(i));
        }
    }

    private void paintTreePolar(Graphics2D g2, TreeElement parent, String treeview) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(parent.getColorLine());
        double[] xBrothers = new double[parent.size()];
        double[] yBrothers = new double[parent.size()];
        double xParent = parent.getX();
        double yParent = parent.getY();
        double parentXCartesian = 0.0;
        if (this.treeView.equalsIgnoreCase("polarDist")) {
            parentXCartesian = this.getXCartesian(xParent - Math.abs(PolarDist.getMinX()), yParent - Math.abs(PolarDist.getMinY()));
        } else if (this.treeView.equalsIgnoreCase("polar")) {
            parentXCartesian = this.getXCartesian(xParent - Math.abs(Polar.getMinX()), yParent - Math.abs(Polar.getMinY()));
        }
        double xParentSized = xParent * this.scaleFactorX + (double)this.marginX;
        double yParentSized = yParent * this.scaleFactorY + (double)this.marginY;
        double xRootSized = 0.0;
        double yRootSized = 0.0;
        if (this.treeView.equalsIgnoreCase("polarDist")) {
            xRootSized = 0.0 + Math.abs(PolarDist.getMinX()) * this.scaleFactorX + (double)this.marginX;
            yRootSized = 0.0 + Math.abs(PolarDist.getMinY()) * this.scaleFactorY + (double)this.marginY;
        } else if (this.treeView.equalsIgnoreCase("polar")) {
            xRootSized = 0.0 + Math.abs(Polar.getMinX()) * this.scaleFactorX + (double)this.marginX;
            yRootSized = 0.0 + Math.abs(Polar.getMinY()) * this.scaleFactorY + (double)this.marginY;
        }
        if (parent.isNode()) {
            double start = 0.0;
            double finish = 0.0;
            double arcRadius = parentXCartesian * this.scaleFactorX;
            for (int i = 0; i < parent.size(); ++i) {
                TreeElement children = (TreeElement)parent.get(i);
                double xChildren = children.getX();
                double yChildren = children.getY();
                xBrothers[i] = xChildren * this.scaleFactorX + (double)this.marginX;
                yBrothers[i] = yChildren * this.scaleFactorY + (double)this.marginY;
                double childrenYCartesian = 0.0;
                if (this.treeView.equalsIgnoreCase("polarDist")) {
                    childrenYCartesian = this.getYCartesian(xChildren - Math.abs(PolarDist.getMinX()), yChildren - Math.abs(PolarDist.getMinY()));
                } else if (this.treeView.equalsIgnoreCase("polar")) {
                    childrenYCartesian = this.getYCartesian(xChildren - Math.abs(Polar.getMinX()), yChildren - Math.abs(Polar.getMinY()));
                }
                if (i == 0) {
                    start = this.getAngle(childrenYCartesian);
                    continue;
                }
                finish = this.getAngle(childrenYCartesian);
            }
            double middleAngle = (finish + start) / 2.0;
            double invertedAngle = -middleAngle;
            double radians = Math.toRadians(invertedAngle);
            double arcCenterX = xParentSized - arcRadius * Math.cos(radians);
            double arcCenterY = yParentSized - arcRadius * Math.sin(radians);
            Arc2D.Double arc = new Arc2D.Double();
            if (parent.isRoot()) {
                double rootX = xRootSized + arcRadius * Math.cos(radians);
                double rootY = yRootSized + arcRadius * Math.sin(radians);
                double parentStartX = xRootSized + arcRadius * Math.cos(Math.toRadians(-start));
                double parentStartY = yRootSized + arcRadius * Math.sin(Math.toRadians(-start));
                double parentFinishX = xRootSized + arcRadius * Math.cos(Math.toRadians(-finish));
                double parentFinishY = yRootSized + arcRadius * Math.sin(Math.toRadians(-finish));
                g2.drawLine((int)rootX, (int)rootY, (int)xRootSized, (int)yRootSized);
                g2.drawLine((int)parentStartX, (int)parentStartY, (int)xBrothers[0], (int)yBrothers[0]);
                try {
                    g2.drawLine((int)parentFinishX, (int)parentFinishY, (int)xBrothers[2], (int)yBrothers[2]);
                    g2.drawLine((int)rootX, (int)rootY, (int)xBrothers[1], (int)yBrothers[1]);
                }
                catch (Exception e) {
                    System.out.printf("NO third brother", new Object[0]);
                    g2.drawLine((int)parentFinishX, (int)parentFinishY, (int)xBrothers[1], (int)yBrothers[1]);
                }
                arc.setArcByCenter(xRootSized, yRootSized, arcRadius, start, finish - start, 0);
            } else {
                double parentStartX = arcCenterX + arcRadius * Math.cos(Math.toRadians(-start));
                double parentStartY = arcCenterY + arcRadius * Math.sin(Math.toRadians(-start));
                double parentFinishX = arcCenterX + arcRadius * Math.cos(Math.toRadians(-finish));
                double parentFinishY = arcCenterY + arcRadius * Math.sin(Math.toRadians(-finish));
                g2.drawLine((int)parentFinishX, (int)parentFinishY, (int)xBrothers[1], (int)yBrothers[1]);
                g2.drawLine((int)parentStartX, (int)parentStartY, (int)xBrothers[0], (int)yBrothers[0]);
                arc.setArcByCenter(arcCenterX, arcCenterY, arcRadius, start, finish - start, 0);
            }
            g2.draw(arc);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.paintTreePolar(g2, (TreeElement)parent.get(i), this.treeView);
        }
    }

    private double getXCartesian(double xP, double yP) {
        return Math.sqrt(xP * xP + yP * yP);
    }

    private double getYCartesian(double xP, double yP) {
        double angle = Math.toDegrees(Math.atan2(yP, xP));
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle / 360.0;
    }

    private double getAngle(double y) {
        double angle = y * this.angularRange;
        return -(angle %= 360.0);
    }

    public void setTreeList(TreeElement treeList) {
        this.treeList = treeList;
        this.bimage = null;
        this.repaint();
    }

    public void setScaleFactorX(double scaleFactorX) {
        this.scaleFactorX = scaleFactorX;
        this.bimage = null;
        this.repaint();
    }

    public void setScaleFactorY(double scaleFactorY) {
        this.scaleFactorY = scaleFactorY;
        this.bimage = null;
        this.repaint();
    }

    public void setMarginX(int marginX) {
        this.marginX = marginX;
        this.bimage = null;
        this.repaint();
    }

    public void setMarginY(int marginY) {
        this.marginY = marginY;
        this.bimage = null;
        this.repaint();
    }

    public double getScaleFactorX() {
        return this.scaleFactorX;
    }

    public double getScaleFactorY() {
        return this.scaleFactorY;
    }

    public BufferedImage getBufferedImage() {
        return this.bimage;
    }

    public void resetBufferedImage() {
        this.bimage = null;
    }

    public void setTreeView(String treeView) {
        this.treeView = treeView;
        this.bimage = null;
    }
}

