/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.TreeElement;
import java.util.ArrayList;

public class NewickToListconFactor {
    private int countTaxa = 0;
    private int countNode = 0;
    private TreeElement treeList;
    private int factor = 1000;
    private double maxLength = 0.0;

    public NewickToListconFactor(String newick) {
        newick = this.cleanNewick(newick);
        this.treeList = this.createList(newick, 0, null);
    }

    private String cleanNewick(String newick) {
        int firstP = newick.indexOf("(");
        int lastP = newick.lastIndexOf(")");
        return newick.substring(firstP, lastP + 1);
    }

    private TreeElement createList(String newick, int level, TreeElement father) {
        TreeElement element;
        int pos = newick.indexOf(",");
        if (pos == -1) {
            String text;
            int id = this.countTaxa++;
            double length = 0.0;
            pos = newick.indexOf(":");
            if (pos != -1) {
                try {
                    length = Double.parseDouble(newick.substring(pos + 1));
                    if (length > this.maxLength) {
                        this.maxLength = length;
                    }
                    if (length < 1.0) {
                        length *= (double)this.factor;
                    }
                }
                catch (Exception ex) {
                    length = 0.0;
                }
                newick = newick.substring(0, pos);
            }
            if ((text = newick.trim()).charAt(0) == '\'') {
                text = text.substring(1);
            }
            if (text.charAt(text.length() - 1) == '\'') {
                text = text.substring(0, text.length() - 1);
            }
            element = new TreeElement(false, id, level, length, 0.0, father);
            element.setText(text);
        } else {
            int i;
            String nodeInfo;
            int id = this.countNode++;
            double length = 0.0;
            double bootstrap = 0.0;
            pos = newick.indexOf("(");
            if (pos == 1) {
                newick = newick.substring(1);
                pos = newick.indexOf("(");
            }
            if ((pos = (nodeInfo = newick.substring(newick.lastIndexOf(")") + 1)).indexOf(":")) != -1) {
                try {
                    length = Double.parseDouble(nodeInfo.substring(pos + 1));
                    if (length > this.maxLength) {
                        this.maxLength = length;
                    }
                    if (length < 1.0) {
                        length *= (double)this.factor;
                    }
                }
                catch (Exception ex) {
                    length = 0.0;
                }
                try {
                    bootstrap = Double.parseDouble(nodeInfo.substring(0, pos));
                }
                catch (Exception ex) {
                    bootstrap = length;
                }
                bootstrap = Math.round(bootstrap);
            }
            element = new TreeElement(true, id, level, length, bootstrap, father);
            if (newick.lastIndexOf(")") != -1) {
                newick = newick.substring(0, newick.lastIndexOf(")"));
            }
            newick = newick.substring(1);
            ArrayList<Object> tab = new ArrayList<Object>();
            int j = 0;
            int nivel = 0;
            tab.add(0, "");
            for (i = 0; i < newick.length(); ++i) {
                if (newick.charAt(i) == '(') {
                    ++nivel;
                } else if (newick.charAt(i) == ')') {
                    --nivel;
                }
                if (nivel == 0 && newick.charAt(i) == ',') {
                    tab.add(++j, "");
                    continue;
                }
                tab.set(j, ((String)tab.get(j)).toString() + newick.charAt(i));
            }
            ++level;
            for (i = 0; i < tab.size(); ++i) {
                TreeElement child = this.createList(((String)tab.get(i)).toString(), level, element);
                element.add(child);
            }
        }
        return element;
    }

    public TreeElement getTreeList() {
        return this.treeList;
    }

    public double getMaxLength() {
        return this.maxLength;
    }
}

