/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.TreeElement;

public class ListToNewick {
    private StringBuffer sbuffer;

    public String getNewickString(TreeElement treeList, boolean hasBootstrap) {
        this.sbuffer = new StringBuffer();
        this.createNewick2(treeList, hasBootstrap);
        this.sbuffer.append(";");
        return this.sbuffer.toString();
    }

    private void createNewick2(TreeElement parent, boolean hasBootstrap) {
        if (parent.isNode()) {
            this.sbuffer.append("(");
        } else {
            this.sbuffer.append(parent.getText());
            this.sbuffer.append(":" + parent.getLength());
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.createNewick2((TreeElement)parent.get(i), hasBootstrap);
            this.sbuffer.append(",");
        }
        if (parent.isNode()) {
            if (this.sbuffer.charAt(this.sbuffer.length() - 1) == ',') {
                this.sbuffer = new StringBuffer(this.sbuffer.substring(0, this.sbuffer.length() - 1));
            }
            this.sbuffer.append(")");
            if (hasBootstrap) {
                this.sbuffer.append(parent.getBootstrap());
            }
            this.sbuffer.append(":" + parent.getLength());
        }
    }
}

