/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.Controller;
import com.biotechvana.phylograph.ListToNewick;
import com.biotechvana.phylograph.PanelTree;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.TreeUtils;
import com.biotechvana.phylograph.View;
import com.biotechvana.phylograph.components.Attachment;
import com.biotechvana.phylograph.components.Bootstrap;
import com.biotechvana.phylograph.components.Bracket;
import com.biotechvana.phylograph.components.ClusterFull;
import com.biotechvana.phylograph.components.ClusterManager;
import com.biotechvana.phylograph.components.Hand;
import com.biotechvana.phylograph.components.Node;
import com.biotechvana.phylograph.components.Otu;
import com.biotechvana.phylograph.components.Scale;
import com.biotechvana.phylograph.components.TextLabel;
import com.biotechvana.phylograph.coords.TreeGram;
import com.biotechvana.phylograph.dialogs.FontDialog2;
import com.biotechvana.phylograph.dialogs.FontDialogCluster;
import com.biotechvana.phylograph.dialogs.FontDialogOtu;
import com.biotechvana.phylograph.exports.ExportHtml;
import com.biotechvana.phylograph.exports.ExportPng;
import com.biotechvana.phylograph.exports.ExportPs;
import com.biotechvana.phylograph.filters.FilterHTML;
import com.biotechvana.phylograph.filters.FilterPNG;
import com.biotechvana.phylograph.filters.FilterPS;
import com.biotechvana.phylograph.internalf.FontSetter;
import com.biotechvana.phylograph.internalf.JsonSaver;
import com.biotechvana.phylograph.internalf.NewickSaver;
import com.biotechvana.phylograph.internalf.NexusSaver;
import com.biotechvana.phylograph.internalf.TreeTypeChanger;
import com.biotechvana.phylograph.readers.PreferenceManager;
import com.biotechvana.phylograph.tables.TableAttachment;
import com.biotechvana.phylograph.tables.TableURL;
import com.biotechvana.phylograph.utils.ImageDim;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class InternalF
extends JInternalFrame {
    private static final long serialVersionUID = 5861633459356093716L;
    private Controller controller = null;
    private View view = null;
    private String treeAbsolutePath = null;
    private TreeElement treeList = null;
    private TreeElement auxList = null;
    private PanelTree panelTree = null;
    private TreeUtils treeUtils = null;
    private TreeGram treegram = null;
    private String treeView = "phylogram";
    private double scaleFactorX = 1.0;
    private double scaleFactorY = 1.0;
    private double scaleInc = 0.2;
    private int marginX = 20;
    private int marginY = 20;
    private int otuPaddingX = 4;
    private String winTitle = "";
    private double maxLength = 0.0;
    private double maxX;
    private Node[] nodeArray;
    private Otu[] otuArray;
    private Bootstrap[] bootArray;
    public static final int OTU = 0;
    public static final int OTULINK = 1;
    public static final int LABEL = 2;
    public static final int BOOTSTRAP = 3;
    public static final int ATTACHMENT = 4;
    public static final int CLUSTER = 5;
    public static final int CLADOGRAM = 0;
    public static final int PHENOGRAM = 1;
    public static final int PHYLOGRAM = 2;
    public static final int SLANTED = 3;
    public static final int UNROOTED = 4;
    public static final int POLAR = 5;
    public static final int NEGATIVE_LEAVE = 0;
    public static final int NEGATIVE_ZERO = 1;
    public static final int NEGATIVE_ABSOLUTE = 2;
    public Font[] fontArray = new Font[]{new Font("SansSerif", 0, 12), new Font("SansSerif", 0, 12), new Font("SansSerif", 1, 12), new Font("SansSerif", 0, 10), new Font("SansSerif", 2, 11), new Font("SansSerif", 0, 12)};
    public Color[] colorArray = new Color[]{Color.BLACK, Color.BLUE, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK};
    private boolean inverted = false;
    private boolean rooted = false;
    private boolean showBootstrap = false;
    private boolean showLink = false;
    private boolean showAttachment = false;
    private boolean negativeLenght = false;
    public boolean showClusters = false;
    private int handConter = 0;
    private int attachmentCounter = 0;
    private List<TextLabel> textLabelList = new ArrayList<TextLabel>();
    private List<Hand> handList = new ArrayList<Hand>();
    private List<Bracket> bracketList = new ArrayList<Bracket>();
    private List<Attachment> attachmentList = new ArrayList<Attachment>();
    private List<ClusterFull> clusterFullList = new ArrayList<ClusterFull>();
    private JScrollPane scroll = new JScrollPane(22, 32);
    private ImageDim dimension = null;
    private FontDialog2 fontDialog2 = new FontDialog2(this.view, "Font settings: ", true);
    private FontDialogOtu fontDialogOtu = new FontDialogOtu(this.view, "Set otu fonts & colors", true);
    private FontDialogCluster fontDialogCluster = new FontDialogCluster(this.view, "Set cluster fonts & colors", true);
    private int attachmentDistance = 100;
    private Scale scale = null;
    private double scaleValue = 100.0;
    private TableURL tableURL = new TableURL(this.view, "URL list:", true);
    private TableAttachment tableAttachment = new TableAttachment(this.view, "Attachment list:", true);
    private String attachmentFileName = null;
    private Object[][] arrayLinks;
    private String urlFileName = null;
    private int treeType = 1;
    private double minBootstrap = 0.0;
    private ExportPng exportPng = new ExportPng();
    private ExportHtml exportHtml = new ExportHtml();
    private ExportPs exportPs = new ExportPs();
    private ListToNewick ltn = new ListToNewick();
    private ClusterManager clusterManager = new ClusterManager();
    private File clusterFile = null;
    private String clusterFileName = null;
    private FontSetter fontSetter = new FontSetter();
    private TreeTypeChanger treeTypeChanger = new TreeTypeChanger();
    private long orginalRootId2 = 0L;
    private TreeElement originalTreeList = null;
    private PreferenceManager preferenceManager = null;
    public int negativeType = 1;

    public InternalF(Controller controller, View view, TreeElement treeL, String fileName, String treeAbsolutePath, int treeType, int frameWidth, int frameHeight, double scaleValue) {
        super(fileName, true, true, true, true);
        int negLen;
        this.winTitle = fileName;
        this.controller = controller;
        this.view = view;
        this.treeAbsolutePath = treeAbsolutePath;
        this.treeList = treeL;
        this.treeType = treeType;
        this.scaleValue = scaleValue;
        this.setPreferredSize(new Dimension(frameWidth, frameHeight));
        this.setResizable(false);
        this.setVisible(true);
        this.pack();
        this.treeUtils = new TreeUtils();
        this.treegram = new TreeGram();
        this.treeList.setRoot(true);
        this.treeUtils.setTotalLength(this.treeList);
        this.treeUtils.setDescendantCount(this.treeList);
        this.treeUtils.orderTree(this.treeList);
        this.maxLength = this.treeUtils.getMaxLength(this.treeList);
        this.negativeLenght = this.treeUtils.hasNegataiveLength(this.treeList);
        if (this.negativeLenght && (negLen = this.alertNegative()) != -1) {
            this.negativeType = negLen;
        }
        this.treeList = this.treegram.getCoords(this.treeList, this.treeView, this.maxLength, this.negativeType);
        this.panelTree = new PanelTree(this.treeList, this, this.treeView);
        this.scroll.getViewport().add(this.panelTree);
        this.getContentPane().add(this.scroll);
        this.panelTree.addMouseListener(new PanelListener());
        if (treeType == 3 || treeType == 4) {
            this.setScaleFactorX(this.scaleFactorX + this.scaleInc);
        }
        double width = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double height = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double marginX = (width - (double)this.fontDialog2.getWidth()) / 2.0;
        double marginY = (height - (double)this.fontDialog2.getHeight()) / 2.0;
        this.fontDialog2.setLocation((int)marginX, (int)marginY);
        if (scaleValue != 0.0 && (this.treeView.equals("phylogram") || this.treeView.equals("unrooted") || this.treeView.equals("polar"))) {
            this.addScale(scaleValue);
        }
        this.getMaxXPosition(this.treeList, 0.0);
        this.moveElements(this.treeList);
        this.updatePanel();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent ce) {
                InternalF.this.fitTreeToWindow();
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
            }

            @Override
            public void componentShown(ComponentEvent ce) {
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
            }
        });
        this.fontDialog2.setLocation(this.getWidth() / 2 - this.fontDialog2.getWidth() / 2, this.getHeight() / 2 - this.fontDialog2.getHeight() / 2);
        this.fontDialogCluster.setLocation(this.getWidth() / 2 - this.fontDialogCluster.getWidth() / 2, this.getHeight() / 2 - this.fontDialogCluster.getHeight() / 2);
        this.orginalRootId2 = ((TreeElement)this.treeList.get(0)).getId2();
        this.originalTreeList = this.treeUtils.copyTree(this.treeList);
        this.loadPreferences();
    }

    public void changeTreeType(String type) {
        this.treeTypeChanger.changeTreeType(this, type, this.maxLength);
        if ((this.treeView.equalsIgnoreCase("unrooted") || this.treeView.equalsIgnoreCase("polar")) && this.clusterFullList != null) {
            this.deleteAllClusters();
        }
    }

    public void invertTree() {
        this.dimension = this.getDim();
        this.treeUtils.invert(this.treeList, (int)this.dimension.getWidth() - this.marginX * 2, this.scaleFactorX);
        this.inverted = !this.inverted;
        this.panelTree.setTreeList(this.treeList);
        this.moveElements(this.treeList);
        this.invertComponents();
    }

    public void setInverted(boolean setInverted) {
        if (setInverted && !this.inverted) {
            this.invertTree();
        }
    }

    public void setScaleFactorX(double scaleFactorX) {
        this.scaleFactorX = scaleFactorX;
        this.panelTree.setScaleFactorX(scaleFactorX);
        this.panelTree.repaint();
        this.moveElements(this.treeList);
        this.updatePanel();
    }

    public void setScaleFactorY(double scaleFactorY) {
        this.scaleFactorY = scaleFactorY;
        this.panelTree.setScaleFactorY(scaleFactorY);
        this.panelTree.repaint();
        this.moveElements(this.treeList);
        this.updatePanel();
    }

    public void setScaleInc(double scaleInc) {
        this.scaleInc = scaleInc;
    }

    public void setMarginX(int marginX) {
        this.marginX = marginX;
        this.treeUtils.orderTree(this.treeList);
        this.panelTree.setMarginX(marginX);
        this.panelTree.repaint();
        this.moveElements(this.treeList);
        this.updatePanel();
    }

    public void setMarginY(int marginY) {
        this.marginY = marginY;
        this.panelTree.setMarginY(marginY);
        this.panelTree.repaint();
        this.moveElements(this.treeList);
        this.updatePanel();
    }

    public void setBootstrap() {
        if (this.showBootstrap) {
            this.showBootstrap = false;
        } else {
            String res = null;
            res = JOptionPane.showInputDialog(this, "Enter minimum value to filter bootstrap: ", String.valueOf(this.minBootstrap));
            if (res == null) {
                this.showBootstrap = false;
            } else {
                double min = 0.0;
                try {
                    min = Double.parseDouble(res);
                }
                catch (NumberFormatException e) {
                    this.showBootstrap = false;
                }
                if (min >= 0.0 && min <= 10000.0) {
                    this.minBootstrap = min;
                    this.showBootstrap = true;
                } else {
                    this.showBootstrap = false;
                }
            }
        }
        this.moveBootstrap(this.treeList, true);
    }

    public void setBootstrap(boolean showBootstrap, double minBootstrap) {
        this.showBootstrap = showBootstrap;
        this.setMinBootstrap(minBootstrap);
        this.moveBootstrap(this.treeList, true);
    }

    public double getScaleFactorX() {
        return this.scaleFactorX;
    }

    public double getScaleFactorY() {
        return this.scaleFactorY;
    }

    public int getMarginX() {
        return this.marginX;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public double getScaleInc() {
        return this.scaleInc;
    }

    public ImageDim getDim() {
        int componentX = 0;
        int componentY = 0;
        this.dimension = this.treeUtils.getMaxDimension(this.treeList);
        Component[] components = this.panelTree.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].isVisible()) continue;
            int tx = components[i].getX() + components[i].getWidth();
            int ty = components[i].getY() + components[i].getHeight();
            if (tx > componentX) {
                componentX = tx;
            }
            if (ty <= componentY) continue;
            componentY = ty;
        }
        componentY -= this.marginY;
        int maxX = (int)(this.dimension.getWidth() * this.scaleFactorX);
        int maxY = (int)(this.dimension.getHeight() * this.scaleFactorY);
        if ((componentX -= this.marginX) > maxX) {
            maxX = componentX;
        }
        if (componentY > maxY) {
            maxY = componentY;
        }
        ImageDim res = new ImageDim(maxX, maxY);
        res.setSize(maxX + this.marginX * 2, maxY + this.marginY * 2);
        return res;
    }

    public ImageDim getTreeDim() {
        this.dimension = this.treeUtils.getMaxDimension(this.treeList);
        return this.dimension;
    }

    public void updateFonts(Font[] arrayFonts, Color[] arrayColors) {
        this.setFonts(arrayFonts, arrayColors);
        this.moveElements(this.treeList);
        this.updatePanel();
    }

    public void createElements() {
        int i;
        if (this.nodeArray != null) {
            for (i = 0; i < this.nodeArray.length; ++i) {
                try {
                    this.panelTree.remove(this.nodeArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.nodeArray = null;
        this.nodeArray = new Node[this.treeUtils.getNumNode(this.treeList)];
        if (this.otuArray != null) {
            for (i = 0; i < this.otuArray.length; ++i) {
                try {
                    this.panelTree.remove(this.otuArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.otuArray = null;
        this.otuArray = new Otu[this.treeUtils.getNumOtu(this.treeList)];
        this.createTreeElements(this.treeList, null);
        if (this.bootArray != null) {
            for (i = 0; i < this.bootArray.length; ++i) {
                try {
                    this.panelTree.remove(this.bootArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.bootArray = new Bootstrap[this.treeUtils.getNumNode(this.treeList)];
        this.createBootstrap(this.treeList);
        this.panelTree.repaint();
    }

    private void createTreeElements(TreeElement parent, Node father) {
        int id;
        if (parent.isNode()) {
            id = parent.getId();
            int level = parent.getLevel();
            int x = (int)Math.round(parent.getX() * this.scaleFactorX) + this.marginX - 3;
            int y = (int)Math.round(parent.getY() * this.scaleFactorY) + this.marginY - 3;
            this.nodeArray[id] = new Node(this, id, level, 0, 0);
            this.nodeArray[id].setId2(parent.getId2());
            this.nodeArray[id].setRoot(parent.isRoot());
            this.nodeArray[id].setBounds(x, y, 8, 8);
            this.nodeArray[id].setFather(father);
            this.nodeArray[id].setLength(parent.getLength());
            this.nodeArray[id].setBootstrap(parent.getBootstrap());
            this.nodeArray[id].setTreeX(parent.getX());
            this.nodeArray[id].setTreeY(parent.getY());
            father = this.nodeArray[id];
            this.panelTree.add(this.nodeArray[id]);
        } else {
            id = parent.getId();
            String text = parent.getText();
            int level = parent.getLevel();
            double length = parent.getLength();
            double x = parent.getX();
            double y = parent.getY();
            Color colorText = parent.getColorText();
            Font font = parent.getFont();
            if (font == null) {
                font = this.fontArray[0];
            }
            FontMetrics fMetrics = this.getFontMetrics(font);
            this.otuArray[id] = new Otu(this, id, text, level);
            this.otuArray[id].setBounds((int)Math.round(x * this.scaleFactorX) + this.marginX, (int)Math.round(y * this.scaleFactorY) + this.marginY - fMetrics.getHeight() / 2, fMetrics.stringWidth(text), fMetrics.getHeight());
            this.otuArray[id].setId2(parent.getId2());
            this.otuArray[id].setFather(father);
            this.otuArray[id].setTreeX(x);
            this.otuArray[id].setTreeY(y);
            this.otuArray[id].setLength(length);
            this.otuArray[id].setForeground(colorText);
            this.otuArray[id].setFont(font);
            this.panelTree.add(this.otuArray[id]);
        }
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.createTreeElements((TreeElement)iter.next(), father);
        }
    }

    private void createBootstrap(TreeElement parent) {
        if (parent.isNode()) {
            try {
                Font font;
                int id = parent.getId();
                try {
                    font = this.bootArray[id].getFont();
                }
                catch (Exception ex) {
                    font = this.fontArray[3];
                }
                FontMetrics fontMetrics = this.getFontMetrics(font);
                double boot = parent.getBootstrap();
                if (this.treeType == 2) {
                    boot = parent.getLength();
                }
                int x = this.nodeArray[id].getX();
                int y = this.nodeArray[id].getY() - fontMetrics.getHeight() / 2 + 3;
                this.bootArray[id] = new Bootstrap(this, id, boot, x + 6, y);
                this.nodeArray[id].setBootPos(x + 6, y);
                this.panelTree.add(this.bootArray[id]);
                if (this.showBootstrap && boot > this.minBootstrap) {
                    this.bootArray[id].setVisible(true);
                } else {
                    this.bootArray[id].setVisible(false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.createBootstrap((TreeElement)parent.get(i));
        }
    }

    public void moveElements(TreeElement parent) {
        if (this.otuArray != null) {
            this.moveOtu(parent);
        }
        if (this.nodeArray != null) {
            this.moveNodes(parent);
        }
        if (this.bootArray != null) {
            this.moveBootstrap(parent, true);
        }
        this.moveAttachment();
        this.moveScale();
    }

    private void moveNodes(TreeElement parent) {
        if (parent.isNode()) {
            try {
                int id = parent.getId();
                this.nodeArray[id].setBounds((int)(parent.getX() * this.scaleFactorX) + this.marginX - 3, (int)(parent.getY() * this.scaleFactorY) + this.marginY - 3, 6, 6);
                this.nodeArray[id].setTreeX(parent.getX());
                this.nodeArray[id].setTreeY(parent.getY());
                this.nodeArray[id].setVisible(parent.isVisible());
                if (!parent.isVisible()) {
                    this.hideElements(parent);
                }
                if (!parent.isVisible()) {
                    this.nodeArray[id].setBounds((int)(parent.getX() * this.scaleFactorX) + this.marginX - 3, (int)(parent.getY() * this.scaleFactorY) + this.marginY - 3, 6, 6);
                    this.nodeArray[id].setVisible(true);
                    this.hideElements(parent);
                    return;
                }
            }
            catch (Exception ex) {
                System.out.println("Move nodes failed");
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.moveNodes((TreeElement)parent.get(i));
        }
    }

    private void getMaxXPosition(TreeElement parent, double xPosition) {
        if (parent.isNode()) {
            for (int i = 0; i < parent.size(); ++i) {
                TreeElement children = (TreeElement)parent.get(i);
                double length = children.getLength();
                this.getMaxXPosition(children, xPosition + length);
            }
        } else if (xPosition > this.maxX) {
            this.maxX = xPosition * this.scaleFactorX + (double)this.marginX;
        }
    }

    public void moveOtu(TreeElement parent) {
        int x = (int)(parent.getX() * this.scaleFactorX) + this.marginX;
        int y = (int)(parent.getY() * this.scaleFactorY) + this.marginY;
        if (!parent.isNode()) {
            int id = parent.getId();
            Otu otu = this.otuArray[id];
            int w = otu.getWidth();
            int h = otu.getHeight();
            int fontHeight = this.getFontMetrics(otu.getFont()).getHeight();
            if (this.inverted) {
                otu.setBounds(x - w - this.otuPaddingX, y - fontHeight / 2, w, h);
            } else {
                otu.setBounds(x + this.otuPaddingX, y - fontHeight / 2, w, h);
                otu.setTreeX(parent.getX());
                otu.setTreeY(parent.getY());
            }
            if (this.treeView.equalsIgnoreCase("unrooted") || this.treeView.equalsIgnoreCase("polar") || this.treeView.equalsIgnoreCase("polarDist")) {
                if (parent.getX() < this.maxX / 2.0) {
                    otu.setBounds(x - w, y - fontHeight / 2 - 2, w, h);
                }
                otu.setVisible(true);
            } else {
                otu.setVisible(parent.isVisible());
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.moveOtu((TreeElement)parent.get(i));
        }
    }

    private void moveBootstrap(TreeElement parent, boolean show) {
        if (parent.isNode()) {
            try {
                int id = parent.getId();
                Node node = this.nodeArray[id];
                Bootstrap bootstrap = this.bootArray[id];
                int x = node.getX() + node.getBootX();
                int y = node.getY() + node.getBootY();
                boolean visible = true;
                if (this.inverted) {
                    x = node.getX() - node.getBootX() - bootstrap.getWidth() + 6;
                }
                bootstrap.setBounds(x, y, bootstrap.getWidth(), bootstrap.getHeight());
                if (bootstrap.getValue() == 0.0 || !visible || !this.showBootstrap) {
                    visible = false;
                }
                if (visible && bootstrap.getValue() < this.minBootstrap) {
                    visible = false;
                }
                if (!parent.isVisible()) {
                    show = false;
                }
                if (!show) {
                    visible = false;
                }
                if (!parent.isVisible() && this.showBootstrap && bootstrap.getValue() >= this.minBootstrap) {
                    visible = true;
                }
                bootstrap.setVisible(visible);
            }
            catch (Exception ex) {
                System.out.println("Move bootstrap failed");
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.moveBootstrap((TreeElement)parent.get(i), show);
        }
    }

    public void moveAttachment() {
        int distance = 0;
        for (int i = 0; i < this.attachmentList.size(); ++i) {
            try {
                Attachment attachment = this.attachmentList.get(i);
                int id = attachment.getId();
                boolean visible = this.otuArray[id].isVisible();
                boolean group = this.attachmentList.get(i).isGroup();
                int attachmentDist = this.attachmentDistance;
                int otuX = this.otuArray[id].getX();
                int otuY = this.otuArray[id].getY() + this.otuArray[id].getStringHeight() / 2 - attachment.getStringHeight() / 2;
                int otuWidth = this.otuArray[id].getWidth();
                int attachmentWidth = attachment.getWidth();
                if (!group) {
                    attachmentDist = attachment.getOtuMargin();
                }
                if (this.inverted) {
                    distance = otuX + otuWidth - (attachmentDist + attachmentWidth);
                    attachment.setLocation(distance, otuY);
                    attachment.setPosX(distance);
                    attachment.setPosY(otuY);
                } else {
                    attachment.setLocation(otuX + attachmentDist, otuY);
                    attachment.setPosX(otuX + attachmentDist);
                    attachment.setPosY(otuY);
                }
                attachment.setVisible(visible);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void moveScale() {
        if (this.scale != null) {
            double treeHeight = this.getTreeDim().getHeight();
            int marginTop = 30;
            if (this.treeView.equalsIgnoreCase("phylogram")) {
                this.scale.setVisible(true);
            } else if (this.treeView.equalsIgnoreCase("unrooted") || this.treeView.equalsIgnoreCase("polar")) {
                marginTop = 50;
                this.scale.setVisible(true);
            } else {
                this.scale.setVisible(false);
            }
            this.scale.setLocation(this.scale.getX(), (int)(treeHeight * this.getScaleFactorY() + (double)this.getMarginY() + (double)marginTop));
        }
    }

    private void invertComponents() {
        int i;
        int distance = 0;
        int halfWidth = (int)this.dimension.getWidth() / 2;
        for (i = 0; i < this.textLabelList.size(); ++i) {
            try {
                TextLabel textLabel = this.textLabelList.get(i);
                if (this.inverted) {
                    distance = textLabel.getX() - halfWidth;
                    textLabel.setLocation(halfWidth - (distance + textLabel.getWidth()), textLabel.getY());
                    continue;
                }
                distance = halfWidth - (textLabel.getX() + textLabel.getWidth());
                textLabel.setLocation(halfWidth + distance, textLabel.getY());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (i = 0; i < this.handList.size(); ++i) {
            try {
                Hand hand = this.handList.get(i);
                if (this.inverted) {
                    distance = (int)this.dimension.getWidth() - hand.getX();
                    hand.setLocation(distance, hand.getY());
                    continue;
                }
                distance = hand.getX();
                hand.setLocation((int)this.dimension.getWidth() - distance, hand.getY());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (i = 0; i < this.bracketList.size(); ++i) {
            try {
                Bracket bracket = this.bracketList.get(i);
                if (this.inverted) {
                    distance = bracket.getX() - halfWidth;
                    bracket.setLocation(halfWidth - (distance + bracket.getWidth()), bracket.getY());
                    bracket.setInverted(true);
                    continue;
                }
                distance = halfWidth - (bracket.getX() + bracket.getWidth());
                bracket.setLocation(halfWidth + distance, bracket.getY());
                bracket.setInverted(false);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void hideElements(TreeElement parent) {
        for (int i = 0; i < parent.size(); ++i) {
            TreeElement child = (TreeElement)parent.get(i);
            int id = child.getId();
            if (child.isNode()) {
                this.nodeArray[id].setVisible(false);
            } else {
                this.otuArray[id].setVisible(false);
            }
            this.hideElements(child);
        }
    }

    private TextLabel insertLabel(int x, int y, String text) {
        String res = null;
        if (text.equals("") || text == null) {
            res = JOptionPane.showInputDialog("Enter text: ");
            if (res == null || res == "" || res.length() == 0) {
                return null;
            }
        } else {
            res = text;
        }
        TextLabel textlabel = new TextLabel(this, res, x, y);
        this.panelTree.add(textlabel);
        this.textLabelList.add(textlabel);
        this.updatePanel();
        return textlabel;
    }

    private void insertHand(int x, int y) {
        Hand hand = new Hand(this, this.handConter++, x, y);
        hand.setBounds(x, y, 20, 20);
        this.panelTree.add(hand);
        this.handList.add(hand);
        this.updatePanel();
    }

    private Bracket insertBracket(int x, int y, int w, int h) {
        if (w == 0) {
            w = 20;
        }
        if (h == 0) {
            h = 20;
        }
        Bracket bracket = new Bracket(this, x, y, w, h);
        this.panelTree.add(bracket);
        this.bracketList.add(bracket);
        this.updatePanel();
        return bracket;
    }

    public void exportImage(View view) {
        this.updatePanel();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Export as png image");
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FilterPNG());
        int sel = chooser.showSaveDialog(view);
        if (sel != 0) {
            return;
        }
        this.exportPng.exportImageFile(this, chooser.getSelectedFile());
        this.updatePanel();
    }

    public void exportHTMLMap(View view) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Export image and html map file");
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FilterHTML());
        int sel = chooser.showSaveDialog(view);
        if (sel != 0) {
            return;
        }
        this.exportPng.exportImageFile(this, chooser.getSelectedFile());
        this.exportHtml.exportHTMLFile(this, chooser.getSelectedFile());
        this.updatePanel();
    }

    public void exportPostScript(View view) {
        this.updatePanel();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FilterPS());
        chooser.setDialogTitle("Export as PostScript");
        int sel = chooser.showSaveDialog(view);
        if (sel != 0) {
            return;
        }
        this.exportPs.exportPSFile(this, chooser.getSelectedFile(), this.treeView);
    }

    public void saveNewick() {
        NewickSaver newickSaver = new NewickSaver();
        newickSaver.saveNewick(this);
    }

    public void saveNexus() {
        NexusSaver nexusSaver = new NexusSaver();
        nexusSaver.saveNexus(this);
    }

    public void saveJson() {
        JsonSaver jsonSaver = new JsonSaver();
        jsonSaver.saveJson(this);
    }

    public void exit() {
        System.exit(0);
    }

    public void attachmentShow(Object[][] values) {
        for (int i = 0; i < this.otuArray.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                Otu otu = this.otuArray[i];
                int id = otu.getId();
                String text = values[j][1].toString();
                int x = otu.getX() + this.attachmentDistance;
                int y = otu.getY();
                if (!otu.getText().equalsIgnoreCase(values[j][0].toString())) continue;
                Attachment attachment = new Attachment(this, id, text, x, y);
                this.panelTree.add(attachment);
                this.attachmentList.add(this.attachmentCounter++, attachment);
                attachment.setBounds(x, y + otu.getStringHeight() / 2 - attachment.getStringHeight() / 2, attachment.getWidth(), attachment.getHeight());
            }
        }
        this.updatePanel();
        this.showAttachment = true;
    }

    public void attachmentHide() {
        for (int i = 0; i < this.attachmentList.size(); ++i) {
            this.panelTree.remove(this.attachmentList.get(i));
        }
        this.showAttachment = false;
        this.updatePanel();
    }

    public boolean getHostVisible() {
        return this.showAttachment;
    }

    public void showLinks() {
        if (this.showLink) {
            this.removeLinks();
            this.showLink = false;
        } else {
            this.showLinks2();
            this.showLink = true;
        }
    }

    private void showLinks2() {
        this.arrayLinks = this.tableURL.getOtuValues();
        for (int i = 0; i < this.otuArray.length; ++i) {
            String link = this.searchLink(this.otuArray[i].getText());
            if (link == null) continue;
            this.otuArray[i].setLink(link);
            this.otuArray[i].setForeground(this.colorArray[1]);
        }
    }

    public void removeLinks() {
        this.removeLinks(this.treeList);
    }

    private void removeLinks(TreeElement parent) {
        if (!parent.isNode()) {
            int id = parent.getId();
            parent.setLink(null);
            this.otuArray[id].setForeground(Color.BLACK);
            this.otuArray[id].setForeground(this.otuArray[id].getForeground());
            this.otuArray[id].setLink(null);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.removeLinks((TreeElement)parent.get(i));
        }
    }

    public void addScale(double value) {
        if (this.scale != null) {
            this.panelTree.remove(this.scale);
        }
        double y = this.treeUtils.getMaxDimension(this.treeList).getHeight();
        this.scale = new Scale(this, value, this.marginX, (int)y + this.marginY);
        this.panelTree.add(this.scale);
    }

    private String searchLink(String otu) {
        for (int i = 0; i < this.arrayLinks.length; ++i) {
            if (!otu.equalsIgnoreCase(this.arrayLinks[i][0].toString())) continue;
            return this.arrayLinks[i][1].toString();
        }
        return null;
    }

    public void updatePanel() {
        this.panelTree.setTreeList(this.treeList);
        this.dimension = this.getDim();
        this.panelTree.setPreferredSize(new Dimension((int)(this.dimension.getWidth() + 40.0), (int)(this.dimension.getHeight() + 40.0)));
        this.panelTree.resetBufferedImage();
        this.panelTree.repaint();
        this.setSize(this.getSize());
    }

    public Font[] getFonts() {
        return this.fontArray;
    }

    public void setDefaultFonts(Font[] newFontArray, Color[] newColorArray) {
        this.fontSetter.setDefaultFonts(this, newFontArray, newColorArray);
    }

    public void setFonts(Font[] newFontArray, Color[] newColorArray) {
        this.fontSetter.setFonts(this, newFontArray, newColorArray);
    }

    public TableURL getTableURL() {
        return this.tableURL;
    }

    public TableAttachment getTableAttachment() {
        return this.tableAttachment;
    }

    public void attachmentEdit() {
        this.tableAttachment.setVisible(true);
    }

    public void attachmentExport() {
        this.tableAttachment.exportOtu(this.preferenceManager.getPreference("attachment_file"));
    }

    public void attachmentImport() {
        if (this.showAttachment) {
            this.attachmentHide();
            this.showAttachment = false;
        }
        try {
            String res = this.tableAttachment.importOtu();
            if (res != null) {
                this.setAttachmentFileName(res);
                this.tableAttachment.setVisible(true);
                this.attachmentShow(this.tableAttachment.getOtuValues());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Invalid attachment file");
        }
    }

    public void attachmentShow() {
        if (this.getHostVisible()) {
            this.attachmentHide();
        } else {
            this.attachmentShow(this.tableAttachment.getOtuValues());
        }
    }

    public void linkEdit() {
        this.tableURL.setVisible(true);
    }

    public void linkExport() {
        this.tableURL.exportOtu(this.preferenceManager.getPreference("url_file"));
    }

    public void linkImport() {
        String res = this.tableURL.importOtu();
        if (res != null) {
            this.setUrlFileName(res);
            this.tableURL.setVisible(true);
        }
    }

    public String getUrlFileName() {
        return this.urlFileName;
    }

    public void setUrlFileName(String res) {
        this.urlFileName = res;
    }

    public void linkShow() {
        this.showLinks();
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void attachmentGroupAll(boolean option) {
        for (int i = 0; i < this.attachmentList.size(); ++i) {
            try {
                this.attachmentList.get(i).setGroup(option);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getTreeFile() {
        return this.treeAbsolutePath;
    }

    public PanelTree getPanelTree() {
        return this.panelTree;
    }

    public Otu[] getOtuArray() {
        return this.otuArray;
    }

    public Node[] getNodeArray() {
        return this.nodeArray;
    }

    public List<TextLabel> getLabelList() {
        return this.textLabelList;
    }

    public List<Attachment> getAttachmentList() {
        return this.attachmentList;
    }

    public List<Bracket> getBracketList() {
        return this.bracketList;
    }

    public Bootstrap[] getBootArray() {
        return this.bootArray;
    }

    public Scale getScale() {
        return this.scale;
    }

    public boolean isRooted() {
        return this.rooted;
    }

    public void setRooted(boolean option) {
        this.rooted = option;
    }

    public TreeUtils getTreeUtils() {
        return this.treeUtils;
    }

    public TreeElement getTreeList() {
        return this.treeList;
    }

    public TreeElement getAuxList() {
        return this.auxList;
    }

    public void setAuxList(TreeElement auxList) {
        this.auxList = auxList == null ? null : this.treeUtils.copyTree(auxList);
    }

    public void setTreeList(TreeElement treeList) {
        this.treeList = treeList == null ? null : this.treeUtils.copyTree(treeList);
    }

    public TreeGram getTreeGram() {
        return this.treegram;
    }

    public String getTreeView() {
        return this.treeView;
    }

    public FontDialog2 getFontDialog() {
        return this.fontDialog2;
    }

    public int getTreeType() {
        return this.treeType;
    }

    public double getScaleValue() {
        return this.scaleValue;
    }

    public int getAttachmentDistance() {
        return this.attachmentDistance;
    }

    public void setAttachmentDistance(int attachmentDistance) {
        this.attachmentDistance = attachmentDistance;
    }

    public void selectSubtree(Node node) {
        TreeElement subtree = this.treeUtils.getSubtree(this.treeList, node.getId());
        boolean hasBootstrap = false;
        if (this.treeType == 3 || this.treeType == 4) {
            hasBootstrap = true;
        }
        this.ltn.getNewickString(subtree, hasBootstrap);
        this.controller.openTreeFile(this.ltn.getNewickString(subtree, hasBootstrap), this.winTitle + "_subtree", this.treeAbsolutePath);
    }

    public void fitTreeToWindow() {
        this.treeUtils.fitTreeToWindow(this);
    }

    public boolean showBootstrap() {
        return this.showBootstrap;
    }

    public void openClusterFile() {
        this.clusterFile = this.clusterManager.openClusterFile(this, this.view, this.preferenceManager.getPreference("cluster_file"));
        if (this.clusterFile == null) {
            return;
        }
        this.clusterFullList = this.clusterManager.getClusterList(this, this.clusterFile);
        this.clusterManager.paintClusters(this, this.clusterFullList);
        this.showClusters = true;
    }

    public void openClusterFile(File fileName) {
        this.deleteAllClusters();
        if (fileName != null) {
            this.clusterFile = fileName;
            this.clusterFullList = this.clusterManager.getClusterList(this, this.clusterFile);
            this.clusterManager.paintClusters(this, this.clusterFullList);
            this.showClusters = true;
        } else {
            System.out.println("Cluster file not loaded");
        }
    }

    public void saveCluster(int nodeId) {
        if (this.clusterFile == null) {
            JOptionPane.showMessageDialog(this, "Open or create a new cluster file before saving clusters", "Alert", 2);
            return;
        }
        TreeElement subTree = this.treeUtils.getSubtree(this.treeList, nodeId);
        ClusterFull clusterFull = this.clusterManager.createCluster(this.view, this, subTree);
        this.showAllClusters();
        this.clusterFullList.add(clusterFull);
        this.clusterManager.saveClusterInFile(this.clusterFile, this.clusterFullList);
        this.getPanelTree().add(clusterFull);
        this.updatePanel();
    }

    public void updateClusters() {
        if (this.clusterFullList != null) {
            for (ClusterFull cluster : this.clusterFullList) {
                this.getPanelTree().remove(cluster);
            }
            if (this.showClusters) {
                this.openClusterFile(this.clusterFile);
            }
            this.updatePanel();
        }
    }

    public void deleteAllClusters() {
        if (this.clusterFullList != null) {
            for (ClusterFull cluster : this.clusterFullList) {
                this.getPanelTree().remove(cluster);
            }
            this.clusterFile = null;
            this.clusterFullList = null;
            this.updatePanel();
            this.showClusters = false;
        }
    }

    public void showAllClusters() {
        if (this.clusterFile != null) {
            this.openClusterFile(this.clusterFile);
        } else {
            this.openClusterFile();
        }
    }

    public void deleteCluster(ClusterFull cluster) {
        Object[] choices = new String[]{"From screen", "From file", "Cancel"};
        int res = JOptionPane.showOptionDialog(this, "<html><b>Delete this cluster...</b><br>(Deleting from file deletes it permanently)</html>", "Option dialog", 1, -1, null, choices, "From screen");
        switch (res) {
            case 0: {
                this.deleteClusterFromScreen(cluster);
                break;
            }
            case 1: {
                this.deleteClusterFromFile(cluster);
                break;
            }
            case 2: {
                return;
            }
            case -1: {
                return;
            }
        }
        this.updatePanel();
    }

    public void deleteClusterFromScreen(ClusterFull cluster) {
        this.getPanelTree().remove(cluster);
    }

    public void deleteClusterFromFile(ClusterFull cluster) {
        this.deleteClusterFromScreen(cluster);
        boolean modified = false;
        Iterator<ClusterFull> iter = this.clusterFullList.iterator();
        while (!this.clusterFullList.isEmpty() && !modified) {
            ClusterFull clusterTemp = iter.next();
            if (clusterTemp.getId() != cluster.getId()) continue;
            this.clusterFullList.remove(clusterTemp);
            modified = true;
        }
        this.clusterManager.saveClusterInFile(this.clusterFile, this.clusterFullList);
    }

    public void clusterCreateFile() {
        File res = this.clusterManager.createClusterFile(this.view, this.preferenceManager.getPreference("cluster_file"));
        if (res != null) {
            this.clusterFile = res;
        }
    }

    public String getWinTitle() {
        return this.winTitle;
    }

    public void setWinTitle(String winTitle) {
        this.winTitle = winTitle;
    }

    public String getTreeAbsolutePath() {
        return this.treeAbsolutePath;
    }

    public void setTreeAbsolutePath(String treeAbsolutePath) {
        this.treeAbsolutePath = treeAbsolutePath;
    }

    public String getAttachmentFileName() {
        return this.attachmentFileName;
    }

    public void setAttachmentFileName(String attachmentFileName) {
        this.attachmentFileName = attachmentFileName;
    }

    public double getMinBootstrap() {
        return this.minBootstrap;
    }

    public void setMinBootstrap(double minBootstrap) {
        this.minBootstrap = minBootstrap;
    }

    public boolean isShowAttachment() {
        return this.showAttachment;
    }

    public void setShowAttachment(boolean showAttachment) {
        this.showAttachment = showAttachment;
    }

    public int getOtuPaddingX() {
        return this.otuPaddingX;
    }

    public void setOtuPaddingX(int otuPaddingX) {
        this.otuPaddingX = otuPaddingX;
    }

    public void setTreeView(String treeView) {
        this.treeView = treeView;
    }

    public String getClusterFileName() {
        return this.clusterFileName;
    }

    public void setClusterFileName(String clusterFileName) {
        this.clusterFileName = clusterFileName;
    }

    public File getClusterFile() {
        return this.clusterFile;
    }

    public void setClusterFile(File clusterFile) {
        this.clusterFile = clusterFile;
    }

    public void test() {
    }

    public List<ClusterFull> getClusterFullList() {
        return this.clusterFullList;
    }

    public void setClusterFullList(List<ClusterFull> clusterFullList) {
        this.clusterFullList = clusterFullList;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public FontDialogCluster getFontDialogCluster() {
        return this.fontDialogCluster;
    }

    public double getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(double maxLength) {
        this.maxLength = maxLength;
    }

    public void setAllClusterFonts(Font font, Color text, Color stroke, Color background, boolean showBorder, Color cBorder, int paddingX, int paddingY) {
        for (ClusterFull cluster : this.clusterFullList) {
            cluster.setFont(font);
            cluster.setColorText(text);
            cluster.setColorStroke(stroke);
            cluster.setColorBackground(background);
            cluster.setBorder(showBorder);
            cluster.setColorBorder(cBorder);
            cluster.setPaddingX(paddingX);
            cluster.setPaddingY(paddingY);
        }
    }

    public long getOrginalRootId2() {
        return this.orginalRootId2;
    }

    public TreeElement getOriginalTreeList() {
        return this.originalTreeList;
    }

    public FontDialogOtu getFontDialogOtu() {
        return this.fontDialogOtu;
    }

    public void loadPreferences() {
        this.preferenceManager = this.controller.getPrefsManager();
        this.attachmentFileName = this.preferenceManager.getPreference("attachment_file");
        try {
            this.tableAttachment.importOtu(this.attachmentFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Invalid attachment file");
        }
        this.urlFileName = this.preferenceManager.getPreference("url_file");
        this.tableURL.importOtu(this.urlFileName);
        this.clusterFileName = this.preferenceManager.getPreference("cluster_file");
        this.clusterFile = new File(this.clusterFileName);
    }

    public int alertNegative() {
        Object[] choices = new String[]{"Keep values", "Set to zero", "Set to absolute value"};
        int res = JOptionPane.showOptionDialog(this, "<html>Negative length values have been found in this tree.<br>What do you want to do with negative values?</html>", "Phylograph message: negative values", 0, 3, null, choices, "Set to absolute value");
        return res;
    }

    public boolean isShowClusters() {
        return this.showClusters;
    }

    public void setShowClusters(boolean showClusters) {
        this.showClusters = showClusters;
    }

    public void adjustClusters() {
        if (this.isShowClusters()) {
            this.showAllClusters();
        }
    }

    class PanelListener
    implements MouseListener {
        private JPopupMenu pop = new JPopupMenu();
        private int posX = 0;
        private int posY = 0;

        private void createPop() {
            JMenuItem label = new JMenuItem("Insert label");
            JMenuItem hand = new JMenuItem("Insert hand");
            JMenuItem bracket = new JMenuItem("Insert bracket");
            this.pop.add(label);
            this.pop.add(bracket);
            label.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    InternalF.this.insertLabel(PanelListener.this.posX, PanelListener.this.posY, "");
                }
            });
            hand.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    InternalF.this.insertHand(PanelListener.this.posX, PanelListener.this.posY);
                }
            });
            bracket.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    InternalF.this.insertBracket(PanelListener.this.posX, PanelListener.this.posY, 0, 0);
                }
            });
        }

        public PanelListener() {
            this.createPop();
            InternalF.this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            this.checkPopupTrigger(me);
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            this.checkPopupTrigger(me);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            this.checkPopupTrigger(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.checkPopupTrigger(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.checkPopupTrigger(me);
        }

        private void checkPopupTrigger(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.pop.show(InternalF.this.panelTree, me.getX(), me.getY());
                this.posX = me.getX();
                this.posY = me.getY();
            }
        }
    }
}

