/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.CustomJDialog;
import com.biotechvana.phylograph.HelpLauncher;
import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.Model;
import com.biotechvana.phylograph.NewickToList;
import com.biotechvana.phylograph.ParseTreeFile;
import com.biotechvana.phylograph.Redimensiona;
import com.biotechvana.phylograph.SwingWorker;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.TreeType;
import com.biotechvana.phylograph.TreeUtils;
import com.biotechvana.phylograph.View;
import com.biotechvana.phylograph.dialogs.FontDialog;
import com.biotechvana.phylograph.filters.FilterPhylo;
import com.biotechvana.phylograph.project.ProjectOpener;
import com.biotechvana.phylograph.project.ProjectSaver;
import com.biotechvana.phylograph.readers.PreferenceManager;
import com.biotechvana.phylograph.utils.FileToString;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class Controller {
    private View view;
    private Model model;
    private final FontDialog fontDialog;
    private TreeType treeType;
    private TreeUtils treeUtils;
    private ArrayList<String> wintitleList;
    private ProjectOpener projectOpener;
    private ProjectSaver projectSaver;
    private PreferenceManager prefsManager;
    private HelpLauncher helpLauncher;
    private static final String helpFile = "help/phylograph_1.0.pdf";
    String xtreeString;
    File xtreeFile;
    CustomJDialog dialog;

    public Controller(View view, Model model, String projectFileName) {
        this.fontDialog = new FontDialog(this.view, "Font settings:", true);
        this.treeType = new TreeType();
        this.treeUtils = new TreeUtils();
        this.wintitleList = new ArrayList();
        this.projectOpener = new ProjectOpener();
        this.projectSaver = new ProjectSaver();
        this.prefsManager = new PreferenceManager();
        this.helpLauncher = new HelpLauncher();
        this.dialog = new CustomJDialog();
        this.view = view;
        this.model = model;
        this.addListners();
        double width = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double height = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double marginX = (width - (double)this.fontDialog.getWidth()) / 2.0;
        double marginY = (height - (double)this.fontDialog.getHeight()) / 2.0;
        this.fontDialog.setLocation((int)marginX, (int)marginY);
        if (projectFileName != null) {
            this.openTreeFromStart(projectFileName);
        }
    }

    private final void addListners() {
        this.view.addOpenTreeFileListener(new OpenTreeFileListener());
        this.view.addOpenProjectListener(new OpenProjectListener());
        this.view.addExpandXListener(new ExpandXListener());
        this.view.addContractXListener(new ContractXListener());
        this.view.addExpandYListener(new ExpandYListener());
        this.view.addContractYListener(new ContractYListener());
        this.view.addExpandAllListener(new ExpandAllListener());
        this.view.addCompressAllListener(new CompressAllListener());
        this.view.addFitListener(new FitTreeToWindowListener());
        this.view.addIncreaseMXListener(new IncreaseMXListener());
        this.view.addIncreaseMYListener(new IncreaseMYListener());
        this.view.addDecreaseMXListener(new DecreaseMXListener());
        this.view.addDecreaseMYListener(new DecreaseMYListener());
        this.view.addFontListener(new FontListener());
        this.view.addInvertListener(new InvertListener());
        this.view.addTreeTypeListener(new TreeTypeListener());
        this.view.addBootstrapListener(new BootstrapListner());
        this.view.addClusterOpenListener(new ClusterOpenListener());
        this.view.addClusterCreateFileListener(new ClusterCreateFileListener());
        this.view.addClusterDeleteListener(new ClusterDeleteListener());
        this.view.addTestListener(new TestListener());
        this.view.addAttachmentEditListener(new AttachmentEditListener());
        this.view.addAttachmentExportListener(new AttachmentExportListener());
        this.view.addAttachmentImportListener(new AttachmentImportListener());
        this.view.addAttachmentShowListener(new AttachmentShowListener());
        this.view.addLinkEditListener(new LinkEditListener());
        this.view.addLinkExportListener(new LinkExportListener());
        this.view.addLinkImportListener(new LinkImportListener());
        this.view.addLinkShowListener(new LinkShowListener());
        this.view.addExportHTMLListener(new ExportHTMLListener());
        this.view.addExportImageListener(new ExportImageListener());
        this.view.addExportPsListener(new ExportPSListener());
        this.view.addSaveProjectListener(new SaveProjectListener());
        this.view.addSaveProjectAsListener(new SaveProjectAsListener());
        this.view.addWindowTileListener(new WindowTileListener());
        this.view.addSaveNewickListener(new SaveNewickListener());
        this.view.addSaveNexusListener(new SaveNexusListener());
        this.view.addSaveJsonListener(new SaveJsonListener());
        this.view.addTestListTreeListener(new ListTreeListener());
        this.view.addHelpAboutListener(new HelpAboutListener());
        this.view.addHelpContentsListener(new HelpContentsListener());
        this.view.addExitListener(new ExitListener());
    }

    public File showOpenTreeDialog() {
        FileDialog dialog;
        String treefileDir = this.prefsManager.getPreference("treefile_dir");
        Frame frame = (Frame)SwingUtilities.getWindowAncestor(this.view);
        if (treefileDir != null) {
            dialog = new FileDialog(frame, "Open a treefile", 0);
            dialog.setDirectory(treefileDir);
        } else {
            dialog = new FileDialog(frame, "Open a treefile", 0);
        }
        dialog.setMultipleMode(false);
        dialog.setVisible(true);
        String selectedFile = dialog.getFile();
        if (selectedFile == null) {
            return null;
        }
        String filePath = dialog.getDirectory() + selectedFile;
        this.prefsManager.savePreference("treefile_dir", dialog.getDirectory());
        return new File(filePath);
    }

    private void checkMultiTree(String treeString, String fileName, String absolutePath) {
        if (treeString.indexOf(";") == treeString.lastIndexOf(";")) {
            this.openTreeFile(treeString, fileName, absolutePath);
        } else {
            StringTokenizer tokens = new StringTokenizer(treeString.trim(), ";");
            int counter = 1;
            while (tokens.hasMoreTokens()) {
                String treeText = tokens.nextToken();
                if (treeText.indexOf("(") == -1) continue;
                this.openTreeFile(tokens.nextToken(), fileName + "_" + String.valueOf(counter++), absolutePath);
            }
        }
        this.windowTile();
    }

    public void openTreeFile(String treeString, String fileName, String treeAbsolutePath) {
        ParseTreeFile ptf = new ParseTreeFile(treeString);
        NewickToList ntl = new NewickToList(ptf.getNewick());
        Redimensiona redimensiona = new Redimensiona();
        int tType = this.treeType.getTreeType(ntl.getTreeList());
        int activeFrameX = 0;
        int activeFrameY = 0;
        double scaleValue = 0.0;
        double maxLength = this.treeUtils.getMaxLength(ntl.getTreeList());
        TreeElement treeList = ntl.getTreeList();
        treeList = redimensiona.procesa(treeList, maxLength);
        scaleValue = maxLength <= 0.01 ? 0.001 : (maxLength <= 0.1 ? 0.01 : (maxLength <= 1.0 ? 0.1 : (maxLength <= 10.0 ? 1.0 : 100.0)));
        InternalF intf = new InternalF(this, this.view, treeList, fileName, treeAbsolutePath, tType, this.view.desktop.getWidth(), this.view.desktop.getHeight(), scaleValue);
        intf.setLocation(activeFrameX, activeFrameY);
        intf.setBounds(intf.getX(), intf.getY(), this.view.desktop.getWidth(), this.view.desktop.getHeight());
        intf.addInternalFrameListener(new InternalFListener());
        if (tType == 2) {
            intf.setScaleFactorX(0.1);
            intf.setScaleInc(0.1);
        }
        intf.moveScale();
        intf.createElements();
        intf.updatePanel();
        this.openTree(fileName);
        intf.fitTreeToWindow();
        this.view.desktop.add(intf);
        try {
            intf.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public void openTreeFromStart(String fileName) {
        File treeFile = new File(fileName);
        if (treeFile == null) {
            return;
        }
        FileToString fts = new FileToString();
        String treeString = fts.getString(treeFile);
        this.checkMultiTree(treeString, treeFile.getName(), treeFile.getAbsolutePath());
    }

    private void openProject() {
        InternalF internalF = this.projectOpener.open(this.view, this);
        if (internalF == null) {
            return;
        }
        this.openTree(internalF.getWinTitle());
        internalF.setLocation(0, 0);
        internalF.addInternalFrameListener(new InternalFListener());
        try {
            internalF.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void openProjectFromStart(String projectFileName) {
        InternalF internalF = this.projectOpener.open(this.view, this, projectFileName);
        if (internalF == null) {
            return;
        }
        this.openTree(internalF.getWinTitle());
        internalF.setLocation(0, 0);
        internalF.addInternalFrameListener(new InternalFListener());
        try {
            internalF.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void saveProject() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF activeIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        if (activeIFrame.getWinTitle().endsWith(".phylo")) {
            this.projectSaver.save(new File(activeIFrame.getTreeAbsolutePath()), activeIFrame);
            return;
        }
        this.saveProjectAs();
    }

    private void saveProjectAs() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF activeIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        File output = this.saveProjectDialog();
        if (output == null) {
            return;
        }
        this.projectSaver.save(output, activeIFrame);
        activeIFrame.setWinTitle(output.getName() + ".phylo");
        activeIFrame.setTitle(output.getName() + ".phylo");
    }

    private File saveProjectDialog() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Save project as...");
        chooser.addChoosableFileFilter(new FilterPhylo());
        int sel = chooser.showSaveDialog(this.view);
        if (sel == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private void saveNewick() {
        InternalF activeIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        activeIFrame.saveNewick();
    }

    private void saveNexus() {
        InternalF activeIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        activeIFrame.saveNexus();
    }

    private void saveJson() {
        InternalF activeIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        activeIFrame.saveJson();
    }

    private void exit() {
        InternalF activeIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        activeIFrame.exit();
    }

    private void expandX() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.setScaleFactorX(selectedIFrame.getScaleFactorX() + selectedIFrame.getScaleFactorX() * 0.1);
        selectedIFrame.adjustClusters();
    }

    private void contractX() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        double newScale = selectedIFrame.getScaleFactorX() - selectedIFrame.getScaleFactorX() * 0.1;
        if (newScale <= 0.0) {
            return;
        }
        selectedIFrame.setScaleFactorX(newScale);
        selectedIFrame.adjustClusters();
    }

    private void expandY() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.setScaleFactorY(selectedIFrame.getScaleFactorY() + selectedIFrame.getScaleFactorY() * 0.1);
        selectedIFrame.adjustClusters();
    }

    private void contractY() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        double newScale = selectedIFrame.getScaleFactorY() - selectedIFrame.getScaleFactorY() * 0.1;
        if (newScale <= 0.0) {
            return;
        }
        selectedIFrame.setScaleFactorY(newScale);
        selectedIFrame.adjustClusters();
    }

    private void increaseMarginX() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.setMarginX(selectedIFrame.getMarginX() + 10);
        selectedIFrame.adjustClusters();
    }

    private void expandAll() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        double newScaleX = selectedIFrame.getScaleFactorX() * 1.1;
        double newScaleY = selectedIFrame.getScaleFactorY() * 1.1;
        selectedIFrame.setScaleFactorX(newScaleX);
        selectedIFrame.setScaleFactorY(newScaleY);
        selectedIFrame.adjustClusters();
    }

    private void compressAll() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        double newScaleX = selectedIFrame.getScaleFactorX() * 0.9;
        double newScaleY = selectedIFrame.getScaleFactorY() * 0.9;
        selectedIFrame.setScaleFactorX(newScaleX);
        selectedIFrame.setScaleFactorY(newScaleY);
        selectedIFrame.adjustClusters();
    }

    private void fitTree() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        this.treeUtils.fitTreeToWindow(selectedIFrame);
        selectedIFrame.adjustClusters();
    }

    private void decreaseMarginX() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        if (selectedIFrame.getMarginX() > 20) {
            selectedIFrame.setMarginX(selectedIFrame.getMarginX() - 10);
        }
        selectedIFrame.adjustClusters();
    }

    private void increaseMarginY() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.setMarginY(selectedIFrame.getMarginY() + 10);
        selectedIFrame.adjustClusters();
    }

    private void decreaseMarginY() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        if (selectedIFrame.getMarginY() > 20) {
            selectedIFrame.setMarginY(selectedIFrame.getMarginY() - 10);
        }
        selectedIFrame.adjustClusters();
    }

    private void openFontDialog() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        this.fontDialog.setLocation(selectedIFrame.getWidth() / 2 - this.fontDialog.getWidth() / 2, selectedIFrame.getHeight() / 2 - this.fontDialog.getHeight() / 2);
        this.fontDialog.setFontArray(selectedIFrame.getFonts());
        this.fontDialog.setVisible(true);
        Font[] arrayFonts = this.fontDialog.getFontArray();
        Color[] arrayColors = this.fontDialog.getColorArray();
        selectedIFrame.updateFonts(arrayFonts, arrayColors);
    }

    private void invert() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.invertTree();
        this.enableControls(!selectedIFrame.isInverted());
    }

    private void changeTreeType(String type) {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.changeTreeType(type);
        if (type.compareToIgnoreCase("unrooted") == 0 || type.compareToIgnoreCase("polarDist") == 0 || type.compareToIgnoreCase("polar") == 0) {
            this.enableResize(false);
        } else {
            this.enableResize(true);
        }
        selectedIFrame.adjustClusters();
    }

    private void showBootstrap() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.setBootstrap();
    }

    private void clusterCreateFile() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.clusterCreateFile();
    }

    private void clusterDelete() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        if (selectedIFrame.showClusters) {
            selectedIFrame.deleteAllClusters();
        } else {
            selectedIFrame.showAllClusters();
        }
    }

    private void openClusterFile() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.openClusterFile();
    }

    private void attachmentEdit() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.attachmentEdit();
    }

    private void attachmentExport() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.attachmentExport();
    }

    private void attachmentImport() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.attachmentImport();
    }

    private void attachmentShow() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.attachmentShow();
    }

    private void linkEdit() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.linkEdit();
    }

    private void linkExport() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.linkExport();
    }

    private void linkImport() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.linkImport();
    }

    private void linkShow() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.linkShow();
    }

    private void exportHTML() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.exportHTMLMap(this.view);
    }

    private void exportImage() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.exportImage(this.view);
    }

    private void exportPS() {
        if (!this.checkActiveFrame()) {
            return;
        }
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.exportPostScript(this.view);
    }

    private void windowTile() {
        if (!this.checkActiveFrame()) {
            return;
        }
        JInternalFrame[] allFrames = this.view.desktop.getAllFrames();
        int newWidth = this.view.desktop.getWidth() / allFrames.length;
        for (int i = 0; i < allFrames.length; ++i) {
            allFrames[i].setBounds(i * newWidth, 0, newWidth, this.view.desktop.getHeight());
        }
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this.view, "<html><p><b>PhyloGraph v 1.0</b></p><p><br>&copy; Biotech Vana 2007<br><a href='http://www.biotechvana.com'>http://www.biotechvana.com</a></p></html>", "About...", 1);
    }

    private void showHelpContents() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Controller.this.helpLauncher.launchProcess(Controller.helpFile);
                return null;
            }
        };
        worker.start();
    }

    public void enableControls(boolean option) {
        this.view.btnExpandAll.setEnabled(option);
        this.view.btnCompressAll.setEnabled(option);
        this.view.btnIncreaseX.setEnabled(option);
        this.view.btnDecreaseX.setEnabled(option);
        this.view.btnIncreaseY.setEnabled(option);
        this.view.btnDecreaseY.setEnabled(option);
        this.view.btnIncreaseMX.setEnabled(option);
        this.view.btnDecreaseMX.setEnabled(option);
        this.view.btnIncreaseMY.setEnabled(option);
        this.view.btnDecreaseMY.setEnabled(option);
        this.view.btnFit.setEnabled(option);
        this.view.btnBootstrap.setEnabled(option);
        this.view.btnCluster.setEnabled(option);
        this.view.btnUnrooted.setEnabled(option);
        this.view.btnCladogram.setEnabled(option);
        this.view.btnCladogram2.setEnabled(option);
        this.view.btnSlanted.setEnabled(option);
        this.view.btnPhylogram.setEnabled(option);
        this.view.menuSetFont.setEnabled(option);
        this.view.menuAttachmentEdit.setEnabled(option);
        this.view.menuAttachmentImport.setEnabled(option);
        this.view.menuAttachmentExport.setEnabled(option);
        this.view.menuAttachmentShow.setEnabled(option);
        this.view.menuLinkEdit.setEnabled(option);
        this.view.menuLinkImport.setEnabled(option);
        this.view.menuLinkExport.setEnabled(option);
        this.view.menuLinkShow.setEnabled(option);
        if (option) {
            this.checkType();
        }
    }

    private void enableResize(boolean option) {
        this.view.btnIncreaseX.setEnabled(option);
        this.view.btnIncreaseY.setEnabled(option);
        this.view.btnDecreaseX.setEnabled(option);
        this.view.btnDecreaseY.setEnabled(option);
        this.view.btnCluster.setEnabled(option);
    }

    public void checkType() {
        int type = ((InternalF)this.view.desktop.getSelectedFrame()).getTreeType();
        boolean boot = false;
        boolean dist = true;
        if (type == 2 || type == 4) {
            boot = true;
        }
        if (type == 1) {
            dist = false;
        }
        this.enableBootstrap(boot);
        this.enableDistance(dist);
    }

    private void enableBootstrap(boolean option) {
        this.view.btnBootstrap.setEnabled(option);
    }

    private void enableDistance(boolean option) {
        this.view.btnPhylogram.setEnabled(option);
    }

    private void openTree(String filename) {
        JRadioButtonMenuItem radioMenu = new JRadioButtonMenuItem(filename, true);
        radioMenu.addActionListener(new WindowActivameListener());
        this.view.windowGroup.add(radioMenu);
        this.view.menuWindow.add(radioMenu);
        radioMenu.setSelected(true);
        this.wintitleList.add(filename);
    }

    public void closeTree() {
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        for (int i = 0; i < this.view.menuWindow.getMenuComponentCount(); ++i) {
            if (this.view.menuWindow.getItem(i) == null || this.view.menuWindow.getItem(i).getText().compareToIgnoreCase(selectedIFrame.getTitle()) != 0) continue;
            this.view.menuWindow.remove(i);
        }
    }

    private void activateTree(String windowName) {
        JInternalFrame[] listaFrames = this.view.desktop.getAllFrames();
        for (int i = 0; i < listaFrames.length; ++i) {
            if (listaFrames[i].getTitle().compareToIgnoreCase(windowName) != 0) continue;
            try {
                listaFrames[i].setSelected(true);
                continue;
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        }
    }

    public void activateMenuTree() {
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        for (int i = 0; i < this.view.menuWindow.getMenuComponentCount(); ++i) {
            if (this.view.menuWindow.getItem(i) == null || this.view.menuWindow.getItem(i).getText().compareToIgnoreCase(selectedIFrame.getTitle()) != 0) continue;
            this.view.menuWindow.getItem(i).setSelected(true);
        }
    }

    private boolean checkActiveFrame() {
        return this.view.desktop.getAllFrames().length >= 1 && this.view.desktop.getSelectedFrame() != null;
    }

    private void doTest() {
        System.out.println("os:" + System.getProperty("os.name"));
    }

    private void listTree() {
        InternalF selectedIFrame = (InternalF)this.view.desktop.getSelectedFrame();
        selectedIFrame.getTreeUtils().showTree(selectedIFrame.getTreeList(), "");
    }

    public PreferenceManager getPrefsManager() {
        return this.prefsManager;
    }

    final class OpenTreeFileListener
    implements ActionListener {
        OpenTreeFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            File treeFile = null;
            FileToString fts = null;
            String treeString = null;
            treeFile = Controller.this.showOpenTreeDialog();
            if (treeFile == null) {
                return;
            }
            fts = new FileToString();
            Controller.this.xtreeString = treeString = fts.getString(treeFile);
            Controller.this.xtreeFile = treeFile;
            Controller.this.dialog.setVisible(true);
            Controller.this.dialog.setAlwaysOnTop(true);
            Controller.this.dialog.setLocation(200, 200);
            Controller.this.dialog.setModal(false);
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    Controller.this.openTreeFile(Controller.this.xtreeString, Controller.this.xtreeFile.getName(), Controller.this.xtreeFile.getAbsolutePath());
                    return null;
                }

                @Override
                public void finished() {
                    Controller.this.dialog.dispose();
                }
            };
            worker.start();
        }
    }

    final class OpenProjectListener
    implements ActionListener {
        OpenProjectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.openProject();
        }
    }

    final class ExpandXListener
    implements ActionListener {
        ExpandXListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.expandX();
        }
    }

    final class ContractXListener
    implements ActionListener {
        ContractXListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.contractX();
        }
    }

    final class ExpandYListener
    implements ActionListener {
        ExpandYListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.expandY();
        }
    }

    final class ContractYListener
    implements ActionListener {
        ContractYListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.contractY();
        }
    }

    final class ExpandAllListener
    implements ActionListener {
        ExpandAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.expandAll();
        }
    }

    final class CompressAllListener
    implements ActionListener {
        CompressAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.compressAll();
        }
    }

    final class FitTreeToWindowListener
    implements ActionListener {
        FitTreeToWindowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.fitTree();
        }
    }

    final class IncreaseMXListener
    implements ActionListener {
        IncreaseMXListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.increaseMarginX();
        }
    }

    final class IncreaseMYListener
    implements ActionListener {
        IncreaseMYListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.increaseMarginY();
        }
    }

    final class DecreaseMXListener
    implements ActionListener {
        DecreaseMXListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.decreaseMarginX();
        }
    }

    final class DecreaseMYListener
    implements ActionListener {
        DecreaseMYListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.decreaseMarginY();
        }
    }

    final class FontListener
    implements ActionListener {
        FontListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.openFontDialog();
        }
    }

    final class InvertListener
    implements ActionListener {
        InvertListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.invert();
        }
    }

    final class TreeTypeListener
    implements ActionListener {
        TreeTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.changeTreeType(ae.getActionCommand());
        }
    }

    final class BootstrapListner
    implements ActionListener {
        BootstrapListner() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.showBootstrap();
        }
    }

    final class ClusterOpenListener
    implements ActionListener {
        ClusterOpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.openClusterFile();
        }
    }

    final class ClusterCreateFileListener
    implements ActionListener {
        ClusterCreateFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.clusterCreateFile();
        }
    }

    final class ClusterDeleteListener
    implements ActionListener {
        ClusterDeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.clusterDelete();
        }
    }

    final class TestListener
    implements ActionListener {
        TestListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.doTest();
        }
    }

    final class AttachmentEditListener
    implements ActionListener {
        AttachmentEditListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.attachmentEdit();
        }
    }

    final class AttachmentExportListener
    implements ActionListener {
        AttachmentExportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.attachmentExport();
        }
    }

    final class AttachmentImportListener
    implements ActionListener {
        AttachmentImportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.attachmentImport();
        }
    }

    final class AttachmentShowListener
    implements ActionListener {
        AttachmentShowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.attachmentShow();
        }
    }

    final class LinkEditListener
    implements ActionListener {
        LinkEditListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.linkEdit();
        }
    }

    final class LinkExportListener
    implements ActionListener {
        LinkExportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.linkExport();
        }
    }

    final class LinkImportListener
    implements ActionListener {
        LinkImportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.linkImport();
        }
    }

    final class LinkShowListener
    implements ActionListener {
        LinkShowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.linkShow();
        }
    }

    final class ExportHTMLListener
    implements ActionListener {
        ExportHTMLListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.exportHTML();
        }
    }

    final class ExportImageListener
    implements ActionListener {
        ExportImageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.exportImage();
        }
    }

    final class ExportPSListener
    implements ActionListener {
        ExportPSListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.exportPS();
        }
    }

    final class SaveProjectListener
    implements ActionListener {
        SaveProjectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.saveProject();
        }
    }

    final class SaveProjectAsListener
    implements ActionListener {
        SaveProjectAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.saveProjectAs();
        }
    }

    final class WindowTileListener
    implements ActionListener {
        WindowTileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.windowTile();
        }
    }

    final class SaveNewickListener
    implements ActionListener {
        SaveNewickListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.saveNewick();
        }
    }

    final class SaveNexusListener
    implements ActionListener {
        SaveNexusListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.saveNexus();
        }
    }

    final class SaveJsonListener
    implements ActionListener {
        SaveJsonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.saveJson();
        }
    }

    final class ListTreeListener
    implements ActionListener {
        ListTreeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.listTree();
        }
    }

    final class HelpAboutListener
    implements ActionListener {
        HelpAboutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.showAbout();
        }
    }

    final class HelpContentsListener
    implements ActionListener {
        HelpContentsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.showHelpContents();
        }
    }

    final class ExitListener
    implements ActionListener {
        ExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.exit();
        }
    }

    class InternalFListener
    implements InternalFrameListener {
        InternalFListener() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent arg0) {
            Controller.this.checkType();
            if (((InternalF)Controller.this.view.desktop.getSelectedFrame()).isInverted()) {
                Controller.this.enableControls(false);
            } else {
                Controller.this.enableControls(true);
            }
            Controller.this.activateMenuTree();
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent arg0) {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent arg0) {
            Controller.this.closeTree();
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent arg0) {
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent arg0) {
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent arg0) {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent arg0) {
        }
    }

    class WindowActivameListener
    implements ActionListener {
        WindowActivameListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Controller.this.activateTree(arg0.getActionCommand());
        }
    }
}

