/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

public class ClustalToNewick {
    private String tree;

    public ClustalToNewick(String clustal) {
        this.tree = this.trimLines(clustal);
        this.tree = this.replaceBootstrap(this.tree);
    }

    private String trimLines(String clustal) {
        String[] line = clustal.split("\n");
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < line.length; ++i) {
            res.append(line[i]);
        }
        return res.toString();
    }

    private String replaceBootstrap(String tree) {
        int i;
        String[] part = tree.split(":");
        StringBuffer res = new StringBuffer();
        for (i = 0; i < part.length; ++i) {
            if (part[i].indexOf("[") == -1) continue;
            part[i] = this.moveBootstrap(part[i]);
        }
        for (i = 0; i < part.length - 1; ++i) {
            if (part[i + 1].indexOf(":") != -1) {
                res.append(part[i]);
                continue;
            }
            res.append(part[i] + ":");
        }
        res.append(part[part.length - 1]);
        return res.toString();
    }

    private String moveBootstrap(String input) {
        StringBuffer res = new StringBuffer();
        int posIni = input.indexOf("[");
        int posFin = input.indexOf("]");
        if (posIni != -1) {
            String boot = input.substring(posIni + 1, posFin);
            res.append(boot + ":" + input.substring(0, posIni) + input.substring(posFin + 1));
        } else if (input.charAt(input.length() - 1) == ')') {
            res.append(input);
        } else {
            res.append(input + ":");
        }
        return res.toString();
    }

    public String getNewick() {
        return this.tree;
    }
}

